/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.Converter;
import fitnesse.slim.SlimError;
import fitnesse.slim.converters.ConverterRegistry;
import fitnesse.slim.converters.ElementConverterHelper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class MethodExecutionResult {
    public static final String MESSAGE_S_NO_METHOD_S_D_IN_CLASS_S_AVAILABLE_METHODS_S = "No Method %s[%d] in class %s.\n Available methods:\n%s";
    public static final MethodExecutionResult NO_METHOD_IN_LIBRARIES = new MethodExecutionResult((Object)null, null){

        @Override
        public boolean hasResult() {
            return false;
        }
    };
    private final Object value;
    private final Class<?> type;

    public MethodExecutionResult(Object value, Class<?> type) {
        this.value = value;
        this.type = type;
    }

    public static MethodExecutionResult noMethod(String methodName, Class<?> clazz, int numberOfArgs) {
        return new NoMethod(methodName, clazz, numberOfArgs);
    }

    public static MethodExecutionResult noInstance(String instanceName) {
        return new NoInstance(instanceName);
    }

    public boolean hasResult() {
        return true;
    }

    public Object returnValue() {
        if (this.type == List.class && this.value instanceof List) {
            return this.value;
        }
        return this.toString();
    }

    public String toString() {
        Converter<?> converter = ConverterRegistry.getConverterForClass(this.type);
        if (converter != null) {
            return converter.toString(this.value);
        }
        if (this.value == null) {
            return "null";
        }
        return ElementConverterHelper.elementToString(this.value);
    }

    public boolean hasMethod() {
        return !(this instanceof NoMethod);
    }

    public Object getObject() {
        return this.value;
    }

    public static String methodsToString(Method[] methods) {
        String result = "";
        result = Arrays.stream(methods).map(m -> MethodExecutionResult.methodToString(m)).sorted().collect(Collectors.joining("\n"));
        return result;
    }

    public static String methodToString(Method m) {
        return m.getName() + "(" + MethodExecutionResult.parametersToString(m.getParameterTypes()) + ") -> " + m.getReturnType().toString();
    }

    public static String parametersToString(Class<?>[] parameters) {
        String result = Arrays.stream(parameters).map(Class::getTypeName).collect(Collectors.joining(", "));
        return result;
    }

    public static class InvalidParameters
    extends MethodExecutionResult {
        private final String methodName;
        private final Exception conversionException;

        public InvalidParameters(String methodName, Exception conversonException) {
            super(null, null);
            this.methodName = methodName;
            this.conversionException = conversonException;
        }

        @Override
        public Object returnValue() {
            throw new SlimError(SlimError.extractSlimMessage(this.conversionException.getMessage()) + "\nTried to invoke: " + this.methodName, (Throwable)this.conversionException, "", true);
        }

        @Override
        public boolean hasResult() {
            return false;
        }
    }

    private static class NoInstance
    extends MethodExecutionResult {
        private final String instanceName;

        NoInstance(String instanceName) {
            super(null, null);
            this.instanceName = instanceName;
        }

        @Override
        public Object returnValue() {
            throw new SlimError(String.format("message:<<%s %s.>>", "NO_INSTANCE", this.instanceName));
        }

        @Override
        public boolean hasResult() {
            return false;
        }
    }

    private static class NoMethod
    extends MethodExecutionResult {
        private final int numberOfArgs;
        private final String methodName;
        private final Class<?> clazz;
        private final String description;

        @Override
        public boolean hasResult() {
            return false;
        }

        public NoMethod(String methodName, Class<?> clazz, int numberOfArgs) {
            super(null, null);
            this.methodName = methodName;
            this.clazz = clazz;
            this.numberOfArgs = numberOfArgs;
            this.description = NoMethod.methodsToString(clazz.getMethods());
        }

        @Override
        public Object returnValue() {
            throw new SlimError(String.format(MethodExecutionResult.MESSAGE_S_NO_METHOD_S_D_IN_CLASS_S_AVAILABLE_METHODS_S, this.methodName, this.numberOfArgs, this.clazz.getName(), this.description), "NO_METHOD_IN_CLASS", true);
        }
    }
}

