/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

public class SlimError
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final boolean prettyPrint;

    public SlimError(String s) {
        super(s);
        this.prettyPrint = false;
    }

    public SlimError(String s, String tag, boolean prettyPrint) {
        super(prettyPrint ? SlimError.makeSlimMessage(s, tag) : s);
        this.prettyPrint = prettyPrint;
    }

    public SlimError(String s, Throwable throwable) {
        super(s, throwable);
        this.prettyPrint = false;
    }

    public SlimError(String s, Throwable throwable, String tag, boolean prettyPrint) {
        super(prettyPrint ? SlimError.makeSlimMessage(s, tag) : s, throwable);
        this.prettyPrint = prettyPrint;
    }

    public SlimError(Throwable e) {
        this(e.getClass().getName() + " " + e.getMessage());
    }

    public static String makeSlimMessage(String msg, String tag) {
        StringBuilder sb = new StringBuilder();
        sb.append("message:<<");
        if (tag != null && !tag.isEmpty()) {
            sb.append(tag);
            sb.append(" ");
        }
        if (msg != null && !msg.isEmpty()) {
            sb.append(msg);
        }
        sb.append(">>");
        return sb.toString();
    }

    public static String extractSlimMessage(String msg) {
        msg = msg.replaceFirst(".*message:<<", "");
        msg = msg.replaceFirst(">>", "");
        return msg;
    }

    public static boolean hasSlimMessage(String msg) {
        return msg.contains("message:<<") && msg.contains(">>");
    }
}

