/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.JavaSlimFactory;
import fitnesse.slim.SlimError;
import fitnesse.slim.SlimFactory;
import fitnesse.slim.SlimPipeSocket;
import fitnesse.slim.SlimServer;
import fitnesse.slim.fixtureInteraction.FixtureInteraction;
import fitnesse.socketservice.PlainServerSocketFactory;
import fitnesse.socketservice.ServerSocketFactory;
import fitnesse.socketservice.SslParameters;
import fitnesse.socketservice.SslServerSocketFactory;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import util.CommandLine;

public class SlimService {
    private static final String OPTION_DESCRIPTOR = "[-v] [-i interactionClass] [-s statementTimeout] [-d] [-ssl parameterClass] port";
    private final ServerSocket serverSocket;
    private final SlimServer slimServer;
    private final boolean daemon;
    private final Executor executor = Executors.newFixedThreadPool(5);

    public static void main(String[] args) throws IOException {
        Options options = SlimService.parseCommandLine(args);
        if (options != null) {
            try {
                SlimService.startWithFactory(JavaSlimFactory.createJavaSlimFactory(options), options);
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Exiting as exception occured: " + e.getMessage());
                System.exit(98);
            }
        } else {
            SlimService.parseCommandLineFailed(args);
            System.exit(97);
        }
    }

    protected static void parseCommandLineFailed(String[] args) {
        System.err.println("Invalid command line arguments: " + Arrays.asList(args));
        System.err.println("Usage:");
        System.err.println("    " + SlimService.class.getName() + " " + OPTION_DESCRIPTOR);
    }

    public static void startWithFactory(SlimFactory slimFactory, Options options) throws IOException {
        ServerSocket socket;
        if (options.port == 1) {
            socket = new SlimPipeSocket();
            if (options.daemon) {
                System.err.println("Warning: in Slim Pipe mode the daemon flag is not supported.");
            }
        } else {
            ServerSocketFactory serverSocketFactory = options.useSSL ? new SslServerSocketFactory(true, SslParameters.createSslParameters(options.sslParameterClassName)) : new PlainServerSocketFactory();
            socket = serverSocketFactory.createServerSocket(options.port);
        }
        try {
            SlimService slimservice = new SlimService(slimFactory.getSlimServer(), socket, options.daemon);
            slimservice.accept();
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of Memory. Aborting.");
            e.printStackTrace();
            System.exit(99);
            throw e;
        }
        catch (BindException e) {
            System.err.println("Can not bind to port " + options.port + ". Aborting.");
            e.printStackTrace();
            throw e;
        }
    }

    public static Options parseCommandLine(String[] args) {
        CommandLine commandLine = new CommandLine(OPTION_DESCRIPTOR);
        if (commandLine.parse(args)) {
            boolean verbose = commandLine.hasOption("v");
            String interactionClassName = commandLine.getOptionArgument("i", "interactionClass");
            String portString = commandLine.getArgument("port");
            int port = portString == null ? 1 : Integer.parseInt(portString);
            String statementTimeoutString = commandLine.getOptionArgument("s", "statementTimeout");
            Integer statementTimeout = statementTimeoutString == null ? null : Integer.valueOf(Integer.parseInt(statementTimeoutString));
            boolean daemon = commandLine.hasOption("d");
            String sslParameterClassName = commandLine.getOptionArgument("ssl", "parameterClass");
            boolean useSSL = commandLine.hasOption("ssl");
            FixtureInteraction interaction = JavaSlimFactory.createInteraction(interactionClassName);
            return new Options(verbose, port, interaction, daemon, statementTimeout, useSSL, sslParameterClassName);
        }
        return null;
    }

    public SlimService(SlimServer slimServer, ServerSocket serverSocket, boolean daemon) throws IOException {
        this.daemon = daemon;
        this.slimServer = slimServer;
        this.serverSocket = serverSocket;
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public void accept() throws IOException {
        try {
            if (this.daemon) {
                this.acceptMany();
            } else {
                this.acceptOne();
            }
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of Memory. Aborting");
            e.printStackTrace();
            System.exit(99);
        }
        finally {
            this.serverSocket.close();
        }
    }

    private void acceptMany() throws IOException {
        while (true) {
            final Socket socket = this.serverSocket.accept();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        SlimService.this.handle(socket);
                    }
                    catch (IOException e) {
                        throw new SlimError(e);
                    }
                }
            });
        }
    }

    private void handle(Socket socket) throws IOException {
        try {
            this.slimServer.serve(socket);
        }
        finally {
            socket.close();
        }
    }

    private void acceptOne() throws IOException {
        Socket socket = this.serverSocket.accept();
        this.handle(socket);
    }

    public static class Options {
        public final boolean verbose;
        public final int port;
        public final FixtureInteraction interaction;
        public final boolean daemon;
        public final Integer statementTimeout;
        final boolean useSSL;
        final String sslParameterClassName;

        public Options(boolean verbose, int port, FixtureInteraction interaction, boolean daemon, Integer statementTimeout, boolean useSSL, String sslParameterClassName) {
            this.verbose = verbose;
            this.port = port;
            this.interaction = interaction;
            this.daemon = daemon;
            this.statementTimeout = statementTimeout;
            this.useSSL = useSSL;
            this.sslParameterClassName = sslParameterClassName;
        }
    }
}

