/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SlimSymbol {
    public static final Pattern SYMBOL_PATTERN = Pattern.compile("\\$(([A-Za-z\\p{L}][\\w\\p{L}]*)|`([^`]+)`)");
    public static final Pattern SYMBOL_ASSIGNMENT_PATTERN = Pattern.compile("\\A\\s*\\$([A-Za-z\\p{L}][\\w\\p{L}]*)\\s*=\\s*\\Z");
    protected String replacedString;
    protected SymbolMatcher symbolMatcher;
    protected int startingPosition;

    public static String isSymbolAssignment(String content) {
        if (content == null) {
            return null;
        }
        Matcher matcher = SYMBOL_ASSIGNMENT_PATTERN.matcher(content);
        return matcher.find() ? matcher.group(1) : null;
    }

    public String replace(String s) {
        if (null == s) {
            return null;
        }
        if (SlimSymbol.isSymbolAssignment(s) != null) {
            return s;
        }
        this.replacedString = s;
        this.replaceAllSymbols();
        return this.replacedString;
    }

    private void replaceAllSymbols() {
        this.startingPosition = 0;
        while (this.symbolFound()) {
            this.replaceSymbol();
        }
    }

    private void replaceSymbol() {
        String value = this.formatSymbol();
        String prefix = this.replacedString.substring(0, this.symbolMatcher.getSymbolStartPosition());
        String suffix = this.replacedString.substring(this.symbolMatcher.getSymbolEndPosition());
        this.replacedString = prefix + value + suffix;
        int replacementEnd = this.symbolMatcher.getSymbolStartPosition() + value.length();
        this.startingPosition = Math.min(replacementEnd, this.replacedString.length());
    }

    private String formatSymbol() {
        String value = this.getSymbolValueImpl(this.symbolMatcher);
        if (value == null) {
            return this.symbolMatcher.getSymbolFound();
        }
        String symbolName = this.symbolMatcher.getSymbolName();
        return this.formatSymbolValue(symbolName, value);
    }

    private boolean symbolFound() {
        this.symbolMatcher = new SymbolMatcher(this::getSymbolValue, this.replacedString, this.startingPosition);
        return this.symbolMatcher.found();
    }

    protected String formatSymbolValue(String name, String value) {
        return value;
    }

    protected String getSymbolValueImpl(SymbolMatcher symbolMatcher) {
        return symbolMatcher.getSymbolValue();
    }

    protected abstract String getSymbolValue(String var1);

    public static class SymbolMatcher {
        private final Function<String, String> symbolStore;
        private final Matcher matcher;
        private String fullString;
        private String symbolName;
        private String symbolValue;

        public SymbolMatcher(Function<String, String> symbolStore, String str, int startingPosition) {
            this.symbolStore = symbolStore;
            this.matcher = SYMBOL_PATTERN.matcher(str);
            if (this.matcher.find(startingPosition)) {
                this.fullString = this.matcher.group();
                this.resolveSymbol(this.matcher.group(1));
            }
        }

        public boolean found() {
            return this.getSymbolName() != null;
        }

        public String getSymbolFound() {
            return this.fullString;
        }

        public int getSymbolStartPosition() {
            return this.found() ? this.matcher.start() : -1;
        }

        public int getSymbolEndPosition() {
            return this.found() ? this.matcher.start() + this.getSymbolName().length() + 1 : -1;
        }

        public String getSymbolName() {
            return this.symbolName;
        }

        public String getSymbolValue() {
            return this.symbolValue;
        }

        protected void resolveSymbol(String symbolNameMatch) {
            this.symbolName = symbolNameMatch;
            this.symbolValue = this.symbolStore.apply(this.symbolName);
            if (this.symbolValue == null) {
                for (int i = this.symbolName.length() - 1; i > 0; --i) {
                    String shorterName = this.symbolName.substring(0, i);
                    String shorterValue = this.symbolStore.apply(shorterName);
                    if (shorterValue == null) continue;
                    this.symbolName = shorterName;
                    this.symbolValue = shorterValue;
                    break;
                }
            }
        }
    }
}

