/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.FixtureMethodExecutor;
import fitnesse.slim.JavaSlimFactory;
import fitnesse.slim.Library;
import fitnesse.slim.LibraryMethodExecutor;
import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.MethodExecutionResults;
import fitnesse.slim.MethodExecutor;
import fitnesse.slim.SlimError;
import fitnesse.slim.SlimException;
import fitnesse.slim.SlimExecutionContext;
import fitnesse.slim.SlimHelperLibrary;
import fitnesse.slim.StatementExecutorConsumer;
import fitnesse.slim.StatementExecutorInterface;
import fitnesse.slim.SystemUnderTestMethodExecutor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class StatementExecutor
implements StatementExecutorInterface {
    private static final String SLIM_HELPER_LIBRARY_INSTANCE_NAME = "SlimHelperLibrary";
    public static final String SLIM_AGENT_FIXTURE_HANDLES_SYMBOLS = "SLIM_AGENT_FIXTURE_HANDLES_SYMBOLS";
    private boolean stopRequested = false;
    private SlimExecutionContext context;
    private List<MethodExecutor> executorChain = new ArrayList<MethodExecutor>();
    private Pattern patternOfFixturesHandlingSymbols = null;

    public StatementExecutor() {
        this(new SlimExecutionContext(JavaSlimFactory.createInteraction(null)));
    }

    public StatementExecutor(SlimExecutionContext context) {
        this.context = context;
        this.executorChain.add(new FixtureMethodExecutor(this.context));
        this.executorChain.add(new SystemUnderTestMethodExecutor(this.context));
        this.executorChain.add(new LibraryMethodExecutor(this.context));
        this.addSlimHelperLibraryToLibraries();
    }

    private void addSlimHelperLibraryToLibraries() {
        SlimHelperLibrary slimHelperLibrary = new SlimHelperLibrary();
        slimHelperLibrary.setStatementExecutor(this);
        this.context.addLibrary(new Library(SLIM_HELPER_LIBRARY_INSTANCE_NAME, slimHelperLibrary));
    }

    @Override
    public Object getInstance(String instanceName) {
        return this.context.getInstance(instanceName);
    }

    @Override
    public void setInstance(String actorInstanceName, Object actor) {
        this.context.setInstance(actorInstanceName, actor);
    }

    @Override
    public void addPath(String path) throws SlimException {
        this.context.addPath(path);
    }

    @Override
    public void assign(String name, Object value) {
        this.context.setVariable(name, value);
        this.checkForPatternOfFixturesHandlingSymbols(name);
    }

    @Override
    public Object getSymbol(String symbolName) {
        MethodExecutionResult result = this.context.getVariable(symbolName);
        if (result == null) {
            return null;
        }
        return result.returnValue();
    }

    @Override
    public Object getSymbolObject(String symbolName) {
        MethodExecutionResult result = this.context.getVariable(symbolName);
        if (result == null) {
            return null;
        }
        return result.getObject();
    }

    @Override
    public void create(String instanceName, String className, Object ... args) throws SlimException {
        try {
            this.context.create(instanceName, className, args);
            Object newInstance = this.context.getInstance(instanceName);
            if (newInstance instanceof StatementExecutorConsumer) {
                ((StatementExecutorConsumer)newInstance).setStatementExecutor(this);
            }
        }
        catch (SlimError e) {
            throw new SlimException(String.format("%s[%d]", className, args.length), (Throwable)e, "COULD_NOT_INVOKE_CONSTRUCTOR", true);
        }
        catch (IllegalArgumentException e) {
            throw new SlimException(String.format("%s[%d]", className, args.length), (Throwable)e, "COULD_NOT_INVOKE_CONSTRUCTOR", true);
        }
        catch (InvocationTargetException e) {
            this.checkExceptionForStop(e.getTargetException());
            throw new SlimException(e.getTargetException(), true);
        }
        catch (Throwable e) {
            this.checkExceptionForStop(e);
            throw new SlimException(e);
        }
    }

    @Override
    public Object call(String instanceName, String methodName, Object ... args) throws SlimException {
        try {
            return this.getMethodExecutionResult(instanceName, methodName, args).returnValue();
        }
        catch (Throwable e) {
            this.checkExceptionForStop(e);
            throw new SlimException(e);
        }
    }

    @Override
    public Object callAndAssign(String variable, String instanceName, String methodName, Object ... args) throws SlimException {
        try {
            MethodExecutionResult result = this.getMethodExecutionResult(instanceName, methodName, args);
            this.context.setVariable(variable, result);
            this.checkForPatternOfFixturesHandlingSymbols(variable);
            return result.returnValue();
        }
        catch (Throwable e) {
            this.checkExceptionForStop(e);
            throw new SlimException(e);
        }
    }

    private MethodExecutionResult getMethodExecutionResult(String instanceName, String methodName, Object ... args) throws Throwable {
        MethodExecutionResults results = new MethodExecutionResults();
        Boolean ignoreSymbols = this.ignoreSymbols(instanceName, methodName);
        if (!ignoreSymbols.booleanValue()) {
            args = this.context.replaceSymbols(args);
        }
        for (MethodExecutor anExecutorChain : this.executorChain) {
            MethodExecutionResult result = anExecutorChain.execute(instanceName, methodName, args);
            if (result.hasResult()) {
                return result;
            }
            results.add(result);
        }
        return results.getFirstResult();
    }

    private Boolean ignoreSymbols(String instanceName, String methodName) {
        try {
            if (this.patternOfFixturesHandlingSymbols == null) {
                return false;
            }
            return this.patternOfFixturesHandlingSymbols.matcher(instanceName + "." + methodName).matches();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void checkForPatternOfFixturesHandlingSymbols(String symbolName) {
        block7: {
            if (!SLIM_AGENT_FIXTURE_HANDLES_SYMBOLS.equals(symbolName)) {
                return;
            }
            try {
                MethodExecutionResult mer = this.context.getVariable(SLIM_AGENT_FIXTURE_HANDLES_SYMBOLS);
                if (mer == null) {
                    return;
                }
                try {
                    if (mer.returnValue() == null) {
                        this.patternOfFixturesHandlingSymbols = null;
                        break block7;
                    }
                    this.patternOfFixturesHandlingSymbols = Pattern.compile(mer.returnValue().toString());
                }
                catch (Exception e) {
                    this.patternOfFixturesHandlingSymbols = null;
                }
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private void checkExceptionForStop(Throwable exception) {
        if (SlimException.isStopTestException(exception) || SlimException.isStopSuiteException(exception)) {
            this.stopRequested = true;
        }
    }

    @Override
    public boolean stopHasBeenRequested() {
        return this.stopRequested;
    }

    @Override
    public void reset() {
        this.stopRequested = false;
    }
}

