/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.MethodExecutor;
import fitnesse.slim.SlimError;
import fitnesse.slim.SlimExecutionContext;
import fitnesse.slim.SystemUnderTest;
import java.lang.reflect.Field;

public class SystemUnderTestMethodExecutor
extends MethodExecutor {
    public SystemUnderTestMethodExecutor(SlimExecutionContext context) {
        super(context);
    }

    @Override
    public MethodExecutionResult execute(String instanceName, String methodName, Object[] args) throws Throwable {
        Object instance;
        try {
            instance = this.context.getInstance(instanceName);
        }
        catch (SlimError e) {
            return MethodExecutionResult.noInstance(instanceName + "." + methodName);
        }
        return this.findSystemUnderTest(methodName, instance, instance.getClass(), args);
    }

    private MethodExecutionResult findSystemUnderTest(String methodName, Object instance, Class<?> k, Object[] args) throws Throwable {
        Field[] fields;
        for (Field field : fields = k.getDeclaredFields()) {
            Object systemUnderTest;
            MethodExecutionResult res;
            if (!this.isSystemUnderTest(field) || !(res = this.findAndInvoke(methodName, args, systemUnderTest = field.get(instance))).hasResult()) continue;
            return res;
        }
        return MethodExecutionResult.noMethod(methodName, instance.getClass(), args.length);
    }

    private boolean isSystemUnderTest(Field field) {
        return "systemUnderTest".equals(field.getName()) || field.getAnnotation(SystemUnderTest.class) != null;
    }
}

