/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.converters;

import fitnesse.slim.SlimError;
import fitnesse.slim.converters.ConverterBase;

public class GenericEnumConverter<T extends Enum<T>>
extends ConverterBase<T> {
    private final Class<T> enumClass;

    public GenericEnumConverter(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public String getString(T o) {
        return ((Enum)o).name();
    }

    @Override
    public T getObject(String name) {
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException e) {
            for (Enum value : (Enum[])this.enumClass.getEnumConstants()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return (T)value;
            }
            throw new SlimError(String.format("message:<<Can't convert %s to enum value of type %s.>>", name, this.enumClass.getName()), e);
        }
    }
}

