/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.fixtureInteraction;

import fitnesse.slim.fixtureInteraction.SimpleInteraction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class CachedInteraction
extends SimpleInteraction {
    private static final Constructor<?> noConstructor = NotExisting.class.getConstructors()[0];
    private static final Method noMethod = NotExisting.class.getDeclaredMethods()[0];
    private final Map<String, Constructor<?>> constructorsByClassAndArgs = new HashMap();
    private final Map<String, Class<?>> classCache = new HashMap();
    private final Map<MethodKey, Method> methodsByNameAndArgs = new HashMap<MethodKey, Method>();

    @Override
    protected Constructor<?> getConstructor(Class<?> clazz, Object[] args) {
        String key = this.getConstructorKey(clazz, args);
        Constructor<?> cached = this.constructorsByClassAndArgs.get(key);
        if (cached == noConstructor) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        Constructor<?> constructor = this.handleConstructorCacheMiss(clazz, args);
        if (constructor == null) {
            this.constructorsByClassAndArgs.put(key, noConstructor);
        } else {
            this.constructorsByClassAndArgs.put(key, constructor);
        }
        return constructor;
    }

    protected String getConstructorKey(Class<?> clazz, Object[] args) {
        return clazz.getName() + "_" + args.length;
    }

    @Override
    protected Class<?> getClass(String className) {
        Class<?> cached = this.classCache.get(className);
        if (cached == NotExisting.class) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        Class<?> k = this.handleClassCacheMiss(className);
        if (k == null) {
            this.classCache.put(className, NotExisting.class);
        } else {
            this.classCache.put(className, k);
        }
        return k;
    }

    @Override
    protected Method findMatchingMethod(String methodName, Object instance, Object ... args) {
        MethodKey key = new MethodKey(instance.getClass(), methodName, args.length);
        Method cached = this.methodsByNameAndArgs.get(key);
        if (cached == noMethod) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        Method method = this.handleMethodCacheMiss(methodName, instance, args);
        if (method == null) {
            this.methodsByNameAndArgs.put(key, noMethod);
        } else {
            this.methodsByNameAndArgs.put(key, method);
        }
        return method;
    }

    protected Constructor<?> handleConstructorCacheMiss(Class<?> clazz, Object[] args) {
        return super.getConstructor(clazz, args);
    }

    protected Class<?> handleClassCacheMiss(String className) {
        return super.getClass(className);
    }

    protected Method handleMethodCacheMiss(String methodName, Object instance, Object[] args) {
        return super.findMatchingMethod(methodName, instance, args);
    }

    private static final class NotExisting {
        public void doIt() {
        }
    }

    private static final class MethodKey {
        private final String k;
        private final String method;
        private final int nArgs;

        public MethodKey(Class<?> k, String method, int nArgs) {
            this.k = k.getName();
            this.method = method;
            this.nArgs = nArgs;
        }

        public int hashCode() {
            int result = this.k.hashCode();
            result = 31 * result + this.method.hashCode();
            result = 31 * result + this.nArgs;
            return result;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            if (this.nArgs != methodKey.nArgs) {
                return false;
            }
            if (!this.k.equals(methodKey.k)) {
                return false;
            }
            return this.method.equals(methodKey.method);
        }
    }
}

