/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.fixtureInteraction;

import fitnesse.slim.ConverterSupport;
import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.SlimError;
import fitnesse.slim.StackTraceEnricher;
import fitnesse.slim.fixtureInteraction.FixtureInteraction;
import fitnesse.slim.fixtureInteraction.InteractionAwareFixture;
import fitnesse.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class SimpleInteraction
implements FixtureInteraction {
    private static final Method AROUND_METHOD;
    private List<String> pathsCache = new ArrayList<String>();

    @Override
    public Object createInstance(List<String> paths, String className, Object[] args) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.pathsCache = paths;
        Class<?> k = null;
        try {
            k = this.searchPathsForClass(paths, className);
        }
        catch (SlimError errorClassNotFound) {
            try {
                MethodExecutionResult mER = this.invokeStaticMethod(className, paths, args);
                if (mER != null) {
                    if (mER.hasResult()) {
                        return mER.getObject();
                    }
                    return mER.returnValue();
                }
            }
            catch (Throwable e) {
                throw new InstantiationException("Failed to call static method '" + className + "': " + "\nCaused by: " + e.getClass().getName() + ": " + e.getMessage() + new StackTraceEnricher().getStackTraceAsString(e));
            }
            throw errorClassNotFound;
        }
        Constructor<?> constructor = this.getConstructor(k, args);
        if (constructor == null) {
            throw new SlimError(String.format("message:<<%s %s>>", "NO_CONSTRUCTOR", className));
        }
        return this.newInstance(args, constructor);
    }

    private Object newInstance(Object[] args, Constructor<?> constructor) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Object[] initargs = ConverterSupport.convertArgs(args, constructor.getParameterTypes());
        return this.newInstance(constructor, initargs);
    }

    protected Class<?> searchPathsForClass(List<String> paths, String className) {
        Class<?> k = this.getClass(className);
        if (k == null) {
            k = this.findClassInPaths(paths, className, StringUtils.swapCaseOfFirstLetter(className));
        }
        if (k != null) {
            return k;
        }
        throw new SlimError(String.format("message:<<%s %s>>", "NO_CLASS", className));
    }

    private Class<?> findClassInPaths(List<String> paths, String ... classNames) {
        Class<?> k = null;
        for (int i = 0; i < classNames.length && k == null; ++i) {
            k = this.findClassInPaths(paths, classNames[i]);
        }
        return k;
    }

    private Class<?> findClassInPaths(List<String> paths, String className) {
        Class<?> k = null;
        if (paths == null) {
            return null;
        }
        for (int i = 0; i < paths.size() && k == null; ++i) {
            k = this.getClass(paths.get(i) + "." + className);
        }
        return k;
    }

    protected Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    protected Constructor<?> getConstructor(Class<?> clazz, Object ... args) {
        Constructor<?> defaultConstructor = null;
        Constructor<?> constructorSelectedByType = null;
        int diffCounter = 0;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            int currentDiffCounter;
            Object[] convertedArgs;
            boolean matchedConstructorArgsTypes;
            Class<?>[] constructorArgs = constructor.getParameterTypes();
            if (constructorArgs.length != args.length) continue;
            if (defaultConstructor == null) {
                defaultConstructor = constructor;
            }
            if (!(matchedConstructorArgsTypes = this.hasConstructorArgsTypes(constructorArgs, convertedArgs = this.getConvertedConstructorArgsTypes(constructor, args))) || (currentDiffCounter = this.getConstructorArgsConvertionDiff(args, convertedArgs)) < diffCounter) continue;
            diffCounter = currentDiffCounter;
            constructorSelectedByType = constructor;
        }
        return constructorSelectedByType == null ? defaultConstructor : constructorSelectedByType;
    }

    private boolean hasConstructorArgsTypes(Class<?>[] constructorArgs, Object[] convertedArgs) {
        boolean constructorMatched = true;
        for (int i = 0; i < constructorArgs.length; ++i) {
            if (convertedArgs[i] == null) continue;
            Class<?> classArg = constructorArgs[i];
            Class<?> classInputArg = convertedArgs[i].getClass();
            if (!constructorArgs[i].isAssignableFrom(convertedArgs[i].getClass())) {
                constructorMatched = constructorArgs[i].isPrimitive() ? this.isWrapper(classArg, classInputArg) : false;
            }
            if (!constructorMatched) break;
        }
        return constructorMatched;
    }

    Object[] getConvertedConstructorArgsTypes(Constructor<?> constructor, Object[] args) {
        Type[] argumentTypes = constructor.getGenericParameterTypes();
        try {
            return ConverterSupport.convertArgs(args, argumentTypes);
        }
        catch (Throwable ex) {
            return args;
        }
    }

    private boolean isWrapper(Class<?> classArg, Class<?> classInputArg) {
        return Long.TYPE.equals(classArg) && Long.class.equals(classInputArg) || Double.TYPE.equals(classArg) && Double.class.equals(classInputArg) || Float.TYPE.equals(classArg) && Float.class.equals(classInputArg) || Integer.TYPE.equals(classArg) && Integer.class.equals(classInputArg) || Character.TYPE.equals(classArg) && Character.class.equals(classInputArg) || Short.TYPE.equals(classArg) && Short.class.equals(classInputArg) || Byte.TYPE.equals(classArg) && Byte.class.equals(classInputArg) || Boolean.TYPE.equals(classArg) && Boolean.class.equals(classInputArg);
    }

    protected Object newInstance(Constructor<?> constructor, Object ... initargs) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        return constructor.newInstance(initargs);
    }

    @Override
    public MethodExecutionResult findAndInvoke(String methodName, Object instance, Object ... args) throws Throwable {
        Method method = this.findMatchingMethod(methodName, instance, args);
        if (method != null) {
            return this.invokeMethod(instance, method, args);
        }
        MethodExecutionResult mER = this.invokeStaticMethod(methodName, this.pathsCache, args);
        if (mER != null) {
            return mER;
        }
        return MethodExecutionResult.noMethod(methodName, instance.getClass(), args.length);
    }

    private MethodExecutionResult invokeStaticMethod(String methodName, List<String> paths, Object ... args) throws Throwable {
        int i = methodName.lastIndexOf(46);
        if (i >= 0) {
            String className = methodName.substring(0, i);
            String staticMethodName = methodName.substring(i + 1);
            Class<?> clazz = this.searchPathsForClass(paths, className);
            if (clazz != null) {
                Method method = this.findMatchingMethod(new String[]{staticMethodName}, clazz.getMethods(), args.length);
                if (method != null) {
                    return this.invokeMethod(null, method, args);
                }
                return MethodExecutionResult.noMethod(staticMethodName + "(static)", clazz, args.length);
            }
        }
        return null;
    }

    protected Method findMatchingMethod(String methodName, Object instance, Object ... args) {
        String[] methodNames = new String[]{methodName, StringUtils.swapCaseOfFirstLetter(methodName)};
        return this.findMatchingMethod(methodNames, instance.getClass().getMethods(), args.length);
    }

    private Method findMatchingMethod(String[] methodNames, Method[] methods, int nArgs) {
        Method method = null;
        for (int i = 0; i < methodNames.length && method == null; ++i) {
            method = this.findMatchingMethod(methodNames[i], methods, nArgs);
        }
        return method;
    }

    private Method findMatchingMethod(String methodName, Method[] methods, int nArgs) {
        Method method = null;
        for (int i = 0; i < methods.length && method == null; ++i) {
            if (!this.isMatchingMethod(methods[i], methodName, nArgs)) continue;
            method = methods[i];
        }
        return method;
    }

    private boolean isMatchingMethod(Method method, String methodName, int nArgs) {
        boolean hasMatchingName = method.getName().equals(methodName);
        boolean hasMatchingArguments = method.getParameterTypes().length == nArgs;
        return hasMatchingName && hasMatchingArguments;
    }

    protected MethodExecutionResult invokeMethod(Object instance, Method method, Object[] args) throws Throwable {
        Object[] convertedArgs = null;
        Object retval = null;
        Class<?> retType = method.getReturnType();
        try {
            convertedArgs = this.convertArgs(method, args);
        }
        catch (Exception e) {
            String methodName = method.getDeclaringClass().getName() + "." + MethodExecutionResult.methodToString(method) + "." + (instance == null ? "" : " On instance of: " + instance.getClass().getName());
            return new MethodExecutionResult.InvalidParameters(methodName, e);
        }
        retval = this.callMethod(instance, method, convertedArgs);
        return new MethodExecutionResult(retval, retType);
    }

    protected Object[] convertArgs(Method method, Object[] args) {
        Type[] argumentParameterTypes = method.getGenericParameterTypes();
        return ConverterSupport.convertArgs(args, argumentParameterTypes);
    }

    protected Object callMethod(Object instance, Method method, Object[] convertedArgs) throws Throwable {
        try {
            Object result;
            if (instance instanceof InteractionAwareFixture) {
                Object[] args = new Object[]{this, method, convertedArgs};
                result = this.methodInvoke(AROUND_METHOD, instance, args);
            } else {
                result = this.methodInvoke(method, instance, convertedArgs);
            }
            return result;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e.getTargetException();
        }
    }

    @Override
    public Object methodInvoke(Method method, Object instance, Object ... convertedArgs) throws Throwable {
        try {
            return method.invoke(instance, convertedArgs);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e.getTargetException();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Bad call of: " + method.getDeclaringClass().getName() + "." + method.getName() + "." + (instance == null ? "" : " On instance of: " + instance.getClass().getName()), e);
        }
        catch (Exception e) {
            String methodName = MethodExecutionResult.methodToString(method);
            throw new RuntimeException("Exception when invoking: " + method.getDeclaringClass().getName() + "." + methodName + "." + (instance == null ? "" : " On instance of: " + instance.getClass().getName()), e);
        }
    }

    private int getConstructorArgsConvertionDiff(Object[] args, Object[] convertedArgs) {
        int diffCounter = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || args[i].equals(convertedArgs[i])) continue;
            ++diffCounter;
        }
        return diffCounter;
    }

    static {
        try {
            AROUND_METHOD = InteractionAwareFixture.class.getMethod("aroundSlimInvoke", FixtureInteraction.class, Method.class, Object[].class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

