/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.instructions;

import fitnesse.slim.SlimException;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.InstructionExecutor;
import fitnesse.slim.instructions.InstructionResult;
import java.util.Arrays;
import java.util.Optional;

abstract class CallAndOptionalAssignInstruction
extends Instruction {
    private final String instructionName;
    private Optional<String> symbolName;
    private String instanceName;
    private String methodName;
    private Object[] args;

    protected CallAndOptionalAssignInstruction(String instructionName, String id, Optional<String> symbolName, String instanceName, String methodName, Object[] args) {
        super(id);
        this.instructionName = instructionName;
        this.symbolName = symbolName;
        this.instanceName = instanceName;
        this.methodName = methodName;
        this.args = args;
    }

    @Override
    protected InstructionResult executeInternal(InstructionExecutor executor) throws SlimException {
        Object result = this.symbolName.isPresent() ? executor.callAndAssign(this.symbolName.get(), this.instanceName, this.methodName, this.args) : executor.call(this.instanceName, this.methodName, this.args);
        return new InstructionResult(this.getId(), result);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id='").append(this.getId()).append('\'');
        sb.append(", instruction='").append(this.instructionName).append('\'');
        this.symbolName.ifPresent(sn -> sb.append(", symbolName='").append((String)sn).append('\''));
        sb.append(", instanceName='").append(this.instanceName).append('\'');
        sb.append(", methodName='").append(this.methodName).append('\'');
        sb.append(", args=").append(Arrays.toString(this.args));
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CallAndOptionalAssignInstruction that = (CallAndOptionalAssignInstruction)o;
        if (!Arrays.equals(this.args, that.args)) {
            return false;
        }
        if (!this.instanceName.equals(that.instanceName)) {
            return false;
        }
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        return this.symbolName.equals(that.symbolName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.symbolName.hashCode();
        result = 31 * result + this.instanceName.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + Arrays.hashCode(this.args);
        return result;
    }
}

