/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.socketservice;

import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SslParameters {
    private String keyStoreFilename;
    private String keyStorePassword;
    private String trustStoreFilename;
    private String keyStoreFilenameOld;
    private String keyStorePasswordOld;
    private String trustStoreFilenameOld;

    protected void setKeyStoreFilename(String filename) {
        if (filename != null) {
            this.keyStoreFilename = filename;
        }
    }

    protected void setKeyStorePassword(String value) {
        if (value != null) {
            this.keyStorePassword = value;
        }
    }

    protected void setTrustStoreFilename(String filename) {
        if (filename != null) {
            this.trustStoreFilename = filename;
        }
    }

    private void setProperty(String tag, String value, String defaultValue) {
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            System.clearProperty(tag);
        } else {
            System.setProperty(tag, value);
        }
    }

    protected SslParameters() {
    }

    protected SslParameters(String keyStoreFilename, String keyStorePassword, String trustStoreFilename) {
        this.setKeyStoreFilename(keyStoreFilename);
        this.setKeyStorePassword(keyStorePassword);
        this.setTrustStoreFilename(trustStoreFilename);
    }

    protected void prepareGlobalConfiguration() {
        this.keyStoreFilenameOld = System.getProperty("javax.net.ssl.keyStore");
        this.keyStorePasswordOld = System.getProperty("javax.net.ssl.keyStorePassword");
        this.trustStoreFilenameOld = System.getProperty("javax.net.ssl.trustStore");
        this.setProperty("javax.net.ssl.keyStore", this.keyStoreFilename, "fitnesse.jks");
        this.setProperty("javax.net.ssl.keyStorePassword", this.keyStorePassword, "FitNesse42");
        this.setProperty("javax.net.ssl.trustStore", this.trustStoreFilename, "fitnesse.jks");
    }

    protected void restorePreviousConfiguration() {
        this.setProperty("javax.net.ssl.keyStore", this.keyStoreFilenameOld, this.keyStoreFilenameOld);
        this.setProperty("javax.net.ssl.keyStorePassword", this.keyStorePasswordOld, this.keyStorePasswordOld);
        this.setProperty("javax.net.ssl.trustStore", this.trustStoreFilenameOld, this.trustStoreFilenameOld);
    }

    public static SslParameters createSslParameters(String sslParameterClassName) {
        return SslParameters.createSslParameters(sslParameterClassName, ClassLoader.getSystemClassLoader());
    }

    public static SslParameters createSslParameters(String sslParameterClassName, ClassLoader classLoader) {
        Class<SslParameters> sslParametersInstance;
        if (sslParameterClassName == null || "true".equalsIgnoreCase(sslParameterClassName)) {
            sslParametersInstance = SslParameters.class;
        } else {
            try {
                sslParametersInstance = classLoader.loadClass(sslParameterClassName).asSubclass(SslParameters.class);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Preparing SSL Parameters with Class " + sslParameterClassName + " failed. Class Not Found.", e);
            }
        }
        try {
            return (SslParameters)sslParametersInstance.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Preparing SSL Parameters with Class " + sslParameterClassName + " failed.", e);
        }
    }

    public SSLServerSocketFactory createSSLServerSocketFactory() {
        SSLServerSocketFactory ssf;
        this.prepareGlobalConfiguration();
        try {
            ssf = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        }
        finally {
            this.restorePreviousConfiguration();
        }
        return ssf;
    }

    public SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory ssf;
        this.prepareGlobalConfiguration();
        try {
            ssf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        finally {
            this.restorePreviousConfiguration();
        }
        return ssf;
    }
}

