/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.testrunner.SuiteFilter;
import fitnesse.testrunner.SuiteSpecificationRunner;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SuiteContentsFinder {
    private static final Logger LOG = Logger.getLogger(SuiteContentsFinder.class.getName());
    private final WikiPage pageToRun;
    private final WikiPage wikiRootPage;
    private final SuiteFilter suiteFilter;

    public SuiteContentsFinder(WikiPage pageToRun, SuiteFilter suiteFilter, WikiPage root) {
        this.pageToRun = pageToRun;
        this.wikiRootPage = root;
        this.suiteFilter = suiteFilter != null ? suiteFilter : SuiteFilter.MATCH_ALL;
    }

    public List<WikiPage> getAllPagesToRunForThisSuite() {
        List<Object> testPageList = new LinkedList();
        String content = this.pageToRun.getHtml();
        if (SuiteSpecificationRunner.isASuiteSpecificationsPage(content)) {
            SuiteSpecificationRunner runner = new SuiteSpecificationRunner(this.wikiRootPage);
            if (runner.getPageListFromPageContent(content)) {
                testPageList = runner.testPages();
            }
        } else {
            testPageList = this.getAllTestPagesUnder();
            testPageList.addAll(this.gatherCrossReferencedTestPages());
        }
        return testPageList;
    }

    private List<WikiPage> getAllTestPagesUnder() {
        List<WikiPage> testPages = this.addTestPagesToSuite(this.pageToRun, this.suiteFilter);
        Collections.sort(testPages, new Comparator<WikiPage>(){

            @Override
            public int compare(WikiPage p1, WikiPage p2) {
                try {
                    WikiPagePath path1 = p1.getFullPath();
                    WikiPagePath path2 = p2.getFullPath();
                    return path1.compareTo(path2);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Unable to compare " + p1 + " and " + p2, e);
                    return 0;
                }
            }
        });
        return testPages;
    }

    private List<WikiPage> addTestPagesToSuite(WikiPage page, SuiteFilter suiteFilter) {
        boolean includePage;
        LinkedList<WikiPage> testPages = new LinkedList<WikiPage>();
        boolean bl = includePage = this.isTopPage(page) || !this.isPruned(page);
        if (suiteFilter.isMatchingTest(page) && includePage) {
            testPages.add(page);
        }
        SuiteFilter suiteFilterForChildren = includePage ? suiteFilter.getFilterForTestsInSuite(page) : SuiteFilter.NO_MATCHING;
        for (WikiPage child : SuiteContentsFinder.getChildren(page)) {
            testPages.addAll(this.addTestPagesToSuite(child, suiteFilterForChildren));
        }
        return testPages;
    }

    private boolean isPruned(WikiPage page) {
        return page.getData().hasAttribute("Prune");
    }

    private boolean isTopPage(WikiPage page) {
        return page == this.pageToRun;
    }

    private static List<WikiPage> getChildren(WikiPage page) {
        ArrayList<WikiPage> children = new ArrayList<WikiPage>();
        children.addAll(page.getChildren());
        return children;
    }

    protected List<WikiPage> gatherCrossReferencedTestPages() {
        LinkedList<WikiPage> pages = new LinkedList<WikiPage>();
        this.addAllXRefs(pages, this.pageToRun);
        return pages;
    }

    private void addAllXRefs(List<WikiPage> xrefPages, WikiPage page) {
        List<WikiPage> children = page.getChildren();
        this.addXrefPages(xrefPages, page);
        for (WikiPage child : children) {
            this.addAllXRefs(xrefPages, child);
        }
    }

    private void addXrefPages(List<WikiPage> pages, WikiPage thePage) {
        List<String> pageReferences = WikiPageUtil.getXrefPages(thePage);
        if (pageReferences.isEmpty()) {
            return;
        }
        PageCrawler pageCrawler = thePage.getPageCrawler();
        for (String pageReference : pageReferences) {
            WikiPagePath path = PathParser.parse(pageReference);
            WikiPage referencedPage = pageCrawler.getSiblingPage(path);
            if (referencedPage == null) continue;
            pages.add(referencedPage);
        }
    }
}

