/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class SuiteFilter {
    private static final Logger LOG = Logger.getLogger(SuiteFilter.class.getName());
    private final SuiteTagMatcher notMatchTags;
    private final SuiteTagMatcher matchTags;
    private final String startWithTest;
    public static final SuiteFilter NO_MATCHING = new SuiteFilter(null, null, null, null){

        @Override
        public boolean isMatchingTest(WikiPage testPage) {
            return false;
        }
    };
    public static final SuiteFilter MATCH_ALL = new SuiteFilter(null, null, null, null);

    public SuiteFilter(String orTags, String mustNotMatchTags, String andTags, String startWithTest) {
        this.startWithTest = !"".equals(startWithTest) ? startWithTest : null;
        this.matchTags = andTags != null ? new SuiteTagMatcher(andTags, true, true) : new SuiteTagMatcher(orTags, true, false);
        this.notMatchTags = new SuiteTagMatcher(mustNotMatchTags, false, false);
    }

    public SuiteFilter(String suiteFilter, String excludeSuiteFilter) {
        this.matchTags = new SuiteTagMatcher(suiteFilter, true, false);
        this.notMatchTags = new SuiteTagMatcher(excludeSuiteFilter, false, false);
        this.startWithTest = null;
    }

    public boolean isMatchingTest(WikiPage testPage) {
        PageData data = testPage.getData();
        boolean isTest = data.hasAttribute(PageType.TEST.toString());
        return isTest && this.matchTags.matches(testPage) && !this.notMatchTags.matches(testPage) && this.afterStartingTest(testPage);
    }

    private boolean afterStartingTest(WikiPage testPage) {
        if (this.startWithTest == null) {
            return true;
        }
        PageCrawler crawler = testPage.getPageCrawler();
        WikiPagePath pageName = crawler.getFullPath();
        return pageName.toString().compareTo(this.startWithTest) >= 0;
    }

    public boolean hasMatchingTests() {
        return this != NO_MATCHING;
    }

    public SuiteFilter getFilterForTestsInSuite(WikiPage suitePage) {
        PageData pageData = suitePage.getData();
        if (pageData.hasAttribute(PageType.SUITE.toString()) && this.matchTags.isFiltering() && this.matchTags.matches(suitePage)) {
            return new SuiteFilter(null, this.notMatchTags.tagString, null, this.startWithTest).getFilterForTestsInSuite(suitePage);
        }
        if (this.notMatchTags.matches(suitePage)) {
            return NO_MATCHING;
        }
        return this;
    }

    public String toString() {
        LinkedList<String> criterias = new LinkedList<String>();
        if (this.matchTags.isFiltering()) {
            if (this.matchTags.andStrategy) {
                criterias.add("matches all of '" + this.matchTags.tagString + "'");
            } else {
                criterias.add("matches '" + this.matchTags.tagString + "'");
            }
        }
        if (this.notMatchTags.isFiltering()) {
            criterias.add("doesn't match '" + this.notMatchTags.tagString + "'");
        }
        if (this.startWithTest != null) {
            criterias.add("starts with test '" + this.startWithTest + "'");
        }
        return StringUtils.join(criterias, (String)" & ");
    }

    private class SuiteTagMatcher {
        private static final String LIST_SEPARATOR = "\\s*,\\s*";
        private final List<String> tags;
        final String tagString;
        private final boolean matchIfNoTags;
        private final boolean andStrategy;

        public SuiteTagMatcher(String suiteTags, boolean matchIfNoTags, boolean andStrategy) {
            this.tagString = suiteTags;
            this.tags = StringUtils.isNotBlank((CharSequence)suiteTags) ? Arrays.asList(suiteTags.split(LIST_SEPARATOR)) : null;
            this.matchIfNoTags = matchIfNoTags;
            this.andStrategy = andStrategy;
        }

        boolean isFiltering() {
            return this.tags != null;
        }

        boolean matches(WikiPage wikiPage) {
            return this.tags == null ? this.matchIfNoTags : this.testMatchesQuery(wikiPage);
        }

        private boolean testMatchesQuery(WikiPage wikiPage) {
            String testTagString = this.getTestTags(wikiPage);
            return testTagString != null && this.testTagsMatchQueryTags(testTagString);
        }

        private String getTestTags(WikiPage context) {
            try {
                return context.getData().getAttribute("Suites");
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to retrieve tags for page " + context, e);
                return null;
            }
        }

        private boolean testTagsMatchQueryTags(String testTagString) {
            String[] testTags = testTagString.trim().split(LIST_SEPARATOR);
            if (this.andStrategy) {
                return this.checkIfAllQueryTagsExist(testTags);
            }
            return this.checkIfAnyTestTagMatchesAnyQueryTag(testTags);
        }

        private boolean checkIfAllQueryTagsExist(String[] testTags) {
            for (String queryTag : this.tags) {
                if (this.containsTag(testTags, queryTag)) continue;
                return false;
            }
            return true;
        }

        private boolean checkIfAnyTestTagMatchesAnyQueryTag(String[] testTags) {
            for (String queryTag : this.tags) {
                if (!this.containsTag(testTags, queryTag)) continue;
                return true;
            }
            return false;
        }

        private boolean containsTag(String[] testTags, String queryTag) {
            for (String testTag : testTags) {
                if (!this.tagsMatch(queryTag, testTag)) continue;
                return true;
            }
            return false;
        }

        private boolean tagsMatch(String queryTag, String testTag) {
            return StringUtils.equalsIgnoreCase((CharSequence)StringUtils.trim((String)testTag), (CharSequence)StringUtils.trim((String)queryTag));
        }
    }
}

