/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.testrunner.WikiTestPage;
import fitnesse.wiki.WikiPage;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class TestPageWithSuiteSetUpAndTearDown
extends WikiTestPage {
    private List<WikiPage> suiteSetUps;
    private List<WikiPage> suiteTearDowns;

    public TestPageWithSuiteSetUpAndTearDown(WikiPage sourcePage) {
        super(sourcePage);
    }

    @Override
    protected void includeSetUps(StringBuilder decoratedContent) {
        List<WikiPage> setups = this.getSuiteSetUps();
        this.includePages("Suite Set Ups", setups, this::includeSetUp, decoratedContent);
        super.includeSetUps(decoratedContent);
    }

    @Override
    protected void includeTearDowns(StringBuilder decoratedContent) {
        super.includeTearDowns(decoratedContent);
        List<WikiPage> tearDowns = this.getSuiteTearDowns();
        this.includePages("Suite Tear Downs", tearDowns, this::includeTearDown, decoratedContent);
    }

    public List<WikiPage> getSuiteSetUps() {
        if (this.suiteSetUps == null && !this.isSuiteSetUpOrTearDownPage()) {
            this.suiteSetUps = this.includeAllSetupsAndTearDowns() ? this.findUncles("SuiteSetUp") : this.getListOfNearestUncle("SuiteSetUp");
        }
        return this.suiteSetUps;
    }

    public List<WikiPage> getSuiteTearDowns() {
        if (this.suiteTearDowns == null && !this.isSuiteSetUpOrTearDownPage()) {
            if (this.includeAllSetupsAndTearDowns()) {
                List<WikiPage> uncles = this.findUncles("SuiteTearDown");
                Collections.reverse(uncles);
                this.suiteTearDowns = uncles;
            } else {
                this.suiteTearDowns = this.getListOfNearestUncle("SuiteTearDown");
            }
        }
        return this.suiteTearDowns;
    }

    private List<WikiPage> getListOfNearestUncle(String name) {
        return Optional.ofNullable(this.findInheritedPage(name)).map(Collections::singletonList).orElseGet(Collections::emptyList);
    }

    private boolean includeAllSetupsAndTearDowns() {
        return TestPageWithSuiteSetUpAndTearDown.includeAllSetupsAndTearDowns(this.getSourcePage());
    }

    public static boolean includeAllSetupsAndTearDowns(WikiPage page) {
        String allUncleSuiteSetups = page.getVariable("ALL_UNCLE_SUITE_SETUPS");
        return "true".equalsIgnoreCase(allUncleSuiteSetups);
    }
}

