/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.wiki.WikiPage;

public class WikiPageIdentity {
    public static final String COMMAND_PATTERN = "COMMAND_PATTERN";
    public static final String TEST_RUNNER = "TEST_RUNNER";
    public static final String TEST_SYSTEM = "TEST_SYSTEM";
    private final WikiPage page;
    private final String testSystem;
    private final String testRunner;
    private final String commandPattern;

    public WikiPageIdentity(WikiPage page) {
        this.page = page;
        this.testSystem = this.getTestSystem();
        this.testRunner = this.getTestRunner();
        this.commandPattern = this.getCommandPattern();
    }

    public String getVariable(String name) {
        return this.page.getVariable(name);
    }

    public String testSystem() {
        return this.testSystem;
    }

    private String testRunner() {
        return this.testRunner;
    }

    private String commandPattern() {
        return this.commandPattern;
    }

    private String getTestSystem() {
        String testSystemName = this.getVariable(TEST_SYSTEM);
        if (testSystemName == null) {
            return "fit";
        }
        return testSystemName;
    }

    private String getTestRunner() {
        String program = this.getVariable(TEST_RUNNER);
        if (program == null) {
            program = "";
        }
        return program;
    }

    private String getCommandPattern() {
        String testRunner = this.getVariable(COMMAND_PATTERN);
        if (testRunner == null) {
            testRunner = "";
        }
        return testRunner;
    }

    public int hashCode() {
        return this.testSystem().hashCode() ^ this.testRunner().hashCode() ^ this.commandPattern().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WikiPageIdentity identity = (WikiPageIdentity)obj;
        return identity.testSystem().equals(this.testSystem()) && identity.testRunner().equals(this.testRunner()) && identity.commandPattern().equals(this.commandPattern());
    }
}

