/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.testrunner.ClassPathBuilder;
import fitnesse.testsystems.ClassPath;
import fitnesse.testsystems.TestPage;
import fitnesse.wiki.BaseWikitextPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.MarkUpSystem;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;

public class WikiTestPage
implements TestPage {
    public static final String TEAR_DOWN = "TearDown";
    public static final String SET_UP = "SetUp";
    public static final String SCENARIO_LIBRARY = "ScenarioLibrary";
    private final WikiPage sourcePage;
    private List<WikiPage> scenarioLibraries;
    private WikiPage setUp;
    private WikiPage tearDown;

    public WikiTestPage(WikiPage sourcePage) {
        this.sourcePage = sourcePage;
    }

    public PageData getData() {
        return this.sourcePage.getData();
    }

    @Override
    public String getHtml() {
        if (this.containsWikitext()) {
            String content = this.getDecoratedContent();
            return MarkUpSystem.make().parse(BaseWikitextPage.makeParsingPage((BaseWikitextPage)this.sourcePage), content).translateToHtml();
        }
        return this.sourcePage.getHtml();
    }

    private boolean containsWikitext() {
        return SymbolicPage.containsWikitext(this.sourcePage);
    }

    @Override
    public String getVariable(String variable) {
        return this.sourcePage.getVariable(variable);
    }

    @Override
    public String getFullPath() {
        return PathParser.render(this.sourcePage.getFullPath());
    }

    @Override
    public ClassPath getClassPath() {
        return new ClassPath(new ClassPathBuilder().getClassPath(this.sourcePage), this.getPathSeparator());
    }

    @Override
    public String getContent() {
        if (this.containsWikitext()) {
            return this.getDecoratedContent();
        }
        return this.sourcePage.getData().getContent();
    }

    protected String getPathSeparator() {
        String separator = this.sourcePage.getVariable("PATH_SEPARATOR");
        if (separator == null) {
            separator = File.pathSeparator;
        }
        return separator;
    }

    public WikiPage getSourcePage() {
        return this.sourcePage;
    }

    protected String getDecoratedContent() {
        StringBuilder decoratedContent = new StringBuilder(1024);
        this.includeScenarioLibraries(decoratedContent);
        this.includeSetUps(decoratedContent);
        this.addPageContent(decoratedContent);
        this.includeTearDowns(decoratedContent);
        return decoratedContent.toString();
    }

    protected void addPageContent(StringBuilder decoratedContent) {
        String content = this.getData().getContent();
        decoratedContent.append("\n").append(content).append(content.endsWith("\n") ? "" : "\n");
    }

    protected void includeScenarioLibraries(StringBuilder decoratedContent) {
        List<WikiPage> libraries = this.getScenarioLibraries();
        this.includePages("Scenario Libraries", libraries, this::includeScenarioLibrary, decoratedContent);
    }

    protected void includeSetUps(StringBuilder decoratedContent) {
        this.includeSetUp(this.getSetUp(), decoratedContent);
    }

    protected void includeTearDowns(StringBuilder decoratedContent) {
        this.includeTearDown(this.getTearDown(), decoratedContent);
    }

    protected void includeScenarioLibrary(WikiPage scenarioLibrary, StringBuilder newPageContent) {
        this.includePage(scenarioLibrary, "-c", newPageContent);
    }

    protected void includeSetUp(WikiPage suiteSetUp, StringBuilder newPageContent) {
        this.includePage(suiteSetUp, "-setup", newPageContent);
    }

    protected void includeTearDown(WikiPage suiteTearDown, StringBuilder newPageContent) {
        this.includePage(suiteTearDown, "-teardown", newPageContent);
    }

    protected void includePages(String name, List<WikiPage> pages, BiConsumer<WikiPage, StringBuilder> includePage, StringBuilder decoratedContent) {
        if (pages != null && !pages.isEmpty()) {
            boolean multiplePages;
            boolean bl = multiplePages = pages.size() > 1;
            if (multiplePages) {
                decoratedContent.append("!*> ");
                decoratedContent.append(name);
                decoratedContent.append("\n");
            }
            for (WikiPage page : pages) {
                includePage.accept(page, decoratedContent);
            }
            if (multiplePages) {
                decoratedContent.append("*!\n");
            }
        }
    }

    protected void includePage(WikiPage wikiPage, String arg, StringBuilder newPageContent) {
        if (wikiPage == null) {
            return;
        }
        String pagePathName = this.getPathNameForPage(wikiPage);
        newPageContent.append("!include ").append(arg).append(" .").append(pagePathName).append("\n");
    }

    private String getPathNameForPage(WikiPage page) {
        WikiPagePath pagePath = page.getFullPath();
        return PathParser.render(pagePath);
    }

    public String getPath() {
        return this.getPathNameForPage(this.sourcePage);
    }

    @Override
    public String getName() {
        return this.sourcePage.getName();
    }

    public boolean shouldIncludeScenarioLibraries() {
        String testSystem = this.sourcePage.getVariable("TEST_SYSTEM");
        boolean isSlim = "slim".equalsIgnoreCase(testSystem) || "slimCoverage".equalsIgnoreCase(testSystem);
        String includeScenarioLibraries = this.sourcePage.getVariable("INCLUDE_SCENARIO_LIBRARIES");
        boolean includeScenarios = "true".equalsIgnoreCase(includeScenarioLibraries);
        boolean notIncludeScenarios = "false".equalsIgnoreCase(includeScenarioLibraries);
        return includeScenarios || !notIncludeScenarios && isSlim;
    }

    public List<WikiPage> getScenarioLibraries() {
        if (this.scenarioLibraries == null) {
            this.scenarioLibraries = this.findScenarioLibraries();
        }
        return this.scenarioLibraries;
    }

    public WikiPage getSetUp() {
        if (this.setUp == null && !this.isSuiteSetUpOrTearDownPage()) {
            this.setUp = this.findInheritedPage(SET_UP);
        }
        return this.setUp;
    }

    public WikiPage getTearDown() {
        if (this.tearDown == null && !this.isSuiteSetUpOrTearDownPage()) {
            this.tearDown = this.findInheritedPage(TEAR_DOWN);
        }
        return this.tearDown;
    }

    protected boolean isSuiteSetUpOrTearDownPage() {
        return this.sourcePage.isSuiteSetupOrTearDown();
    }

    protected WikiPage findInheritedPage(String pageName) {
        return this.sourcePage.getPageCrawler().getClosestInheritedPage(pageName);
    }

    private List<WikiPage> findScenarioLibraries() {
        List<WikiPage> uncles = this.shouldIncludeScenarioLibraries() ? this.findUncles(SCENARIO_LIBRARY) : Collections.emptyList();
        return uncles;
    }

    protected List<WikiPage> findUncles(String uncleName) {
        LinkedList<WikiPage> uncles = new LinkedList<WikiPage>();
        this.sourcePage.getPageCrawler().traverseUncles(uncleName, uncles::addFirst);
        return uncles;
    }
}

