/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner.run;

import fitnesse.testrunner.WikiPageIdentity;
import fitnesse.testrunner.run.PageListPartitioner;
import fitnesse.testrunner.run.PagePositions;
import fitnesse.testrunner.run.PagesByTestSystem;
import fitnesse.util.partitioner.ListPartitioner;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PageListPartitionerImpl
implements PageListPartitioner {
    public static final String PARTITION_HEADER = "Partition";
    private ListPartitioner<WikiPage> partitionFunction;

    public PageListPartitionerImpl() {
    }

    public PageListPartitionerImpl(ListPartitioner<WikiPage> partitionFunction) {
        this.partitionFunction = partitionFunction;
    }

    @Override
    public PagesByTestSystem partition(Function<List<WikiPage>, ? extends PagesByTestSystem> factory, List<WikiPage> pages, int partitionCount, int partitionIndex) {
        List<List<WikiPage>> partitionedTests = this.getPartitionsWithOnlyTests(partitionCount, factory.apply(pages));
        List<WikiPage> selectedPartition = partitionedTests.get(partitionIndex);
        return factory.apply(selectedPartition);
    }

    @Override
    public PagePositions findPagePositions(Function<List<WikiPage>, ? extends PagesByTestSystem> factory, List<WikiPage> pages, int partitionCount) {
        List<List<WikiPage>> partitionedTests = partitionCount > 1 ? this.getPartitionsWithOnlyTests(partitionCount, factory.apply(pages)) : Collections.singletonList(pages);
        List<List<WikiPage>> partitions = this.getPartitionsIncludingSetUpAndTearDown(factory, partitionedTests);
        return this.getIndicesPerPage(pages, partitions);
    }

    protected List<List<WikiPage>> getPartitionsWithOnlyTests(int partitionCount, PagesByTestSystem pagesByTestSystem) {
        List<WikiPage> orderedPages = this.getOrderedTestWikiPages(pagesByTestSystem);
        return this.partitionFunction.split(orderedPages, partitionCount);
    }

    protected List<WikiPage> getOrderedTestWikiPages(PagesByTestSystem pagesByTestSystem) {
        List<WikiPage> orderedPages = this.orderPagesByTestSystem(pagesByTestSystem);
        orderedPages.removeIf(WikiPage::isSuiteSetupOrTearDown);
        return orderedPages;
    }

    protected List<List<WikiPage>> getPartitionsIncludingSetUpAndTearDown(Function<List<WikiPage>, ? extends PagesByTestSystem> factory, List<List<WikiPage>> partitionedTests) {
        return partitionedTests.stream().map(factory).map(this::orderPagesByTestSystem).collect(Collectors.toList());
    }

    protected PagePositions getIndicesPerPage(List<WikiPage> allPages, List<List<WikiPage>> partitions) {
        PagePositions allPositions = this.createPagePositions(partitions);
        return this.orderResults(allPages, allPositions);
    }

    protected PagePositions createPagePositions(List<List<WikiPage>> partitions) {
        PagePositions result = new PagePositions();
        result.getGroupNames().addAll(Arrays.asList(PARTITION_HEADER, "Test System"));
        for (int partitionIndex = 0; partitionIndex < partitions.size(); ++partitionIndex) {
            List<WikiPage> partition = partitions.get(partitionIndex);
            for (int indexInPartition = 0; indexInPartition < partition.size(); ++indexInPartition) {
                WikiPage page = partition.get(indexInPartition);
                WikiPageIdentity identity = new WikiPageIdentity(page);
                result.addPosition(page.getFullPath().toString(), Arrays.asList(partitionIndex, identity), indexInPartition);
            }
        }
        return result;
    }

    protected PagePositions orderResults(List<WikiPage> inputPages, PagePositions allPositions) {
        PagePositions result = this.copySelectedKeys(inputPages, allPositions);
        for (String pageName : allPositions.getPages()) {
            if (result.hasPositions(pageName)) continue;
            result.getPositions(pageName).addAll(allPositions.getPositions(pageName));
        }
        return result;
    }

    protected PagePositions copySelectedKeys(List<WikiPage> keysToKeep, PagePositions allPositions) {
        PagePositions results = new PagePositions();
        results.getGroupNames().addAll(allPositions.getGroupNames());
        for (WikiPage page : keysToKeep) {
            String pageName = page.getFullPath().toString();
            results.getPositions(pageName).addAll(allPositions.getPositions(pageName));
        }
        return results;
    }

    protected List<WikiPage> orderPagesByTestSystem(PagesByTestSystem pagesByTestSystem) {
        ArrayList<WikiPage> orderedPages = new ArrayList<WikiPage>(pagesByTestSystem.getSourcePages().size());
        for (WikiPageIdentity identity : pagesByTestSystem.identities()) {
            List<WikiPage> pages = pagesByTestSystem.wikiPagesForIdentity(identity);
            orderedPages.addAll(pages);
        }
        return orderedPages;
    }

    public ListPartitioner<WikiPage> getPartitionFunction() {
        return this.partitionFunction;
    }

    public void setPartitionFunction(ListPartitioner<WikiPage> partitionFunction) {
        this.partitionFunction = partitionFunction;
    }
}

