/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner.run;

import fitnesse.testrunner.run.PageListSetUpTearDownProcessor;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PageListSetUpTearDownInserter
implements PageListSetUpTearDownProcessor {
    @Override
    public List<WikiPage> addSuiteSetUpsAndTearDowns(List<WikiPage> pageList) {
        LinkedList<WikiPage> pagesToRun = new LinkedList<WikiPage>();
        Map<WikiPage, List<WikiPage>> tearDownAfter = this.findPagesBeforeTearDown(pageList);
        HashSet<WikiPage> setupsAdded = new HashSet<WikiPage>();
        for (WikiPage page : pageList) {
            this.addSetUpIfNeeded(pagesToRun, setupsAdded, page);
            pagesToRun.add(page);
            this.addTearDownIfPossible(pagesToRun, tearDownAfter, page);
        }
        return pagesToRun;
    }

    private Map<WikiPage, List<WikiPage>> findPagesBeforeTearDown(List<WikiPage> pages) {
        LinkedHashMap pageBeforeSuiteTearDown = new LinkedHashMap();
        for (WikiPage page : pages) {
            page.getPageCrawler().traverseUncles("SuiteTearDown", suiteTearDown -> {
                pageBeforeSuiteTearDown.remove(suiteTearDown);
                pageBeforeSuiteTearDown.put(suiteTearDown, page);
            });
        }
        IdentityHashMap<WikiPage, List<WikiPage>> tearDownAfter = new IdentityHashMap<WikiPage, List<WikiPage>>();
        for (Map.Entry entry : pageBeforeSuiteTearDown.entrySet()) {
            WikiPage normalPage = (WikiPage)entry.getValue();
            WikiPage tearDownToRun = (WikiPage)entry.getKey();
            tearDownAfter.computeIfAbsent(normalPage, p -> new ArrayList()).add(tearDownToRun);
        }
        return tearDownAfter;
    }

    private void addSetUpIfNeeded(List<WikiPage> pagesToRun, Set<WikiPage> setupsAdded, WikiPage page) {
        this.getClosestInheritedPage(page, "SuiteSetUp").ifPresent(suiteSetUp -> {
            if (setupsAdded.add((WikiPage)suiteSetUp)) {
                WikiPage parent = suiteSetUp.getParent();
                if (!parent.isRoot()) {
                    this.addSetUpIfNeeded(pagesToRun, setupsAdded, parent.getParent());
                }
                pagesToRun.add((WikiPage)suiteSetUp);
            }
        });
    }

    private void addTearDownIfPossible(List<WikiPage> pagesToRun, Map<WikiPage, List<WikiPage>> tearDownAfter, WikiPage page) {
        List<WikiPage> tearDowns = tearDownAfter.get(page);
        if (tearDowns != null) {
            pagesToRun.addAll(tearDowns);
        }
    }

    private Optional<WikiPage> getClosestInheritedPage(WikiPage page, String pageName) {
        return Optional.ofNullable(page.getPageCrawler().getClosestInheritedPage(pageName));
    }
}

