/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner.run;

import fitnesse.testrunner.run.PageListSetUpTearDownProcessor;
import fitnesse.wiki.WikiPage;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PageListSetUpTearDownSurrounder
implements PageListSetUpTearDownProcessor {
    private final Map<String, WikiPage> setUpsAndTearDowns = new HashMap<String, WikiPage>();

    @Override
    public List<WikiPage> addSuiteSetUpsAndTearDowns(List<WikiPage> pageList) {
        Map<String, List<WikiPage>> pageSetUpTearDownGroups = this.createPageSetUpTearDownGroups(pageList);
        return this.reinsertPagesViaSetUpTearDownGroups(pageSetUpTearDownGroups);
    }

    private Map<String, List<WikiPage>> createPageSetUpTearDownGroups(List<WikiPage> pageList) {
        LinkedHashMap<String, List<WikiPage>> pageSetUpTearDownGroups = new LinkedHashMap<String, List<WikiPage>>();
        for (WikiPage page : pageList) {
            this.makeSetUpTearDownPageGroupForPage(page, pageSetUpTearDownGroups);
        }
        return pageSetUpTearDownGroups;
    }

    private void makeSetUpTearDownPageGroupForPage(WikiPage page, Map<String, List<WikiPage>> pageSetUpTearDownGroups) {
        String group = this.getSetUpTearDownGroup(page);
        pageSetUpTearDownGroups.computeIfAbsent(group, g -> new LinkedList()).add(page);
    }

    private String getSetUpTearDownGroup(WikiPage page) {
        String setUpPath = this.getPathForSetUpTearDown(page, "SuiteSetUp");
        String tearDownPath = this.getPathForSetUpTearDown(page, "SuiteTearDown");
        return setUpPath + "," + tearDownPath;
    }

    private String getPathForSetUpTearDown(WikiPage page, String setUpTearDownName) {
        String path = null;
        WikiPage suiteSetUpTearDown = page.getPageCrawler().getClosestInheritedPage(setUpTearDownName);
        if (suiteSetUpTearDown != null) {
            path = suiteSetUpTearDown.getFullPath().toString();
            this.setUpsAndTearDowns.putIfAbsent(path, suiteSetUpTearDown);
        }
        return path;
    }

    private List<WikiPage> reinsertPagesViaSetUpTearDownGroups(Map<String, List<WikiPage>> pageSetUpTearDownGroups) {
        LinkedList<WikiPage> pageList = new LinkedList<WikiPage>();
        for (Map.Entry<String, List<WikiPage>> entry : pageSetUpTearDownGroups.entrySet()) {
            pageList.addAll(this.insertSetUpTearDownPageGroup(entry.getKey(), entry.getValue()));
        }
        return pageList;
    }

    private List<WikiPage> insertSetUpTearDownPageGroup(String setUpAndTearDownGroupKey, List<WikiPage> pageGroup) {
        LinkedList<WikiPage> pageList = new LinkedList<WikiPage>();
        pageList.addAll(this.setUpForThisGroup(setUpAndTearDownGroupKey));
        pageList.addAll(pageGroup);
        pageList.addAll(this.tearDownForThisGroup(setUpAndTearDownGroupKey));
        return pageList;
    }

    private List<WikiPage> setUpForThisGroup(String setUpAndTearDown) {
        String setUpPath = setUpAndTearDown.split(",")[0];
        WikiPage setUpPage = this.setUpsAndTearDowns.get(setUpPath);
        return setUpPage != null ? Collections.singletonList(setUpPage) : Collections.emptyList();
    }

    private List<WikiPage> tearDownForThisGroup(String setUpAndTearDownGroupKey) {
        String tearDownPath = setUpAndTearDownGroupKey.split(",")[1];
        WikiPage tearDownPage = this.setUpsAndTearDowns.get(tearDownPath);
        return tearDownPage != null ? Collections.singletonList(tearDownPage) : Collections.emptyList();
    }
}

