/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner.run;

import fitnesse.testrunner.WikiPageIdentity;
import fitnesse.testrunner.run.PagePosition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.velocity.util.StringBuilderWriter;

public class PagePositions {
    public static final String PAGE_HEADER = "Page";
    public static final String ORDER_HEADER = "Order";
    private final Map<List<Object>, List<Object>> groupCache = new HashMap<List<Object>, List<Object>>();
    private String lineSep = "\n";
    private List<String> groupNames = new ArrayList<String>(2);
    private Map<String, List<PagePosition>> positions = new LinkedHashMap<String, List<PagePosition>>();

    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public Integer getGroupIndex(String name) {
        return this.groupNames.indexOf(name);
    }

    public List<String> getPages() {
        return new ArrayList<String>(this.positions.keySet());
    }

    public List<PagePosition> getPositions(String page) {
        return this.positions.computeIfAbsent(page, p -> new LinkedList());
    }

    public boolean hasPositions(String page) {
        return this.positions.containsKey(page);
    }

    public void addPosition(String page, List<Object> group, int positionInGroup) {
        List groupFromCache = this.groupCache.computeIfAbsent(group, g -> group);
        this.getPositions(page).add(new PagePosition(groupFromCache, positionInGroup));
    }

    public Comparator<String> createByPositionInGroupComparator() {
        HashMap<String, Integer> testOrdering = new HashMap<String, Integer>();
        for (String page : this.getPages()) {
            for (PagePosition pos : this.getPositions(page)) {
                testOrdering.put(page, pos.getPositionInGroup());
            }
        }
        return (page1, page2) -> {
            int pos2;
            int pos1 = testOrdering.getOrDefault(page1, -1);
            return pos1 == (pos2 = testOrdering.getOrDefault(page2, -1).intValue()) ? page1.compareTo((String)page2) : pos1 - pos2;
        };
    }

    public void appendTo(Writer writer, String groupSep) throws IOException {
        this.appendHeader(writer, groupSep);
        for (Map.Entry<String, List<PagePosition>> entry : this.positions.entrySet()) {
            this.appendIndices(writer, entry.getKey(), entry.getValue(), groupSep);
        }
        writer.flush();
    }

    public static PagePositions parseFrom(Reader reader, String groupSep) throws IOException {
        BufferedReader b = new BufferedReader(reader);
        PagePositions positions = new PagePositions();
        positions.parseHeader(b, groupSep);
        positions.parseRows(b, groupSep);
        return positions;
    }

    protected void parseHeader(BufferedReader reader, String groupSep) throws IOException {
        this.splitNextLine(reader, groupSep).map(parts -> Collections.addAll(this.groupNames, this.stripHeadAndTail((String[])parts))).orElseThrow(() -> new IllegalArgumentException("No header line"));
    }

    protected void parseRows(BufferedReader reader, String groupSep) throws IOException {
        Optional<String[]> linePresent;
        while ((linePresent = this.splitNextLine(reader, groupSep)).isPresent()) {
            String[] parts = linePresent.get();
            List<Object> group = Arrays.asList((Object[])this.stripHeadAndTail(parts));
            Integer pos = Integer.valueOf(parts[parts.length - 1]);
            this.addPosition(parts[0], group, pos);
        }
    }

    protected String[] stripHeadAndTail(String[] parts) {
        int count = parts.length;
        if (count < 3) {
            throw new IllegalArgumentException("Expected at least 2 columns, got: " + count);
        }
        return Arrays.copyOfRange(parts, 1, count - 1);
    }

    protected Optional<String[]> splitNextLine(BufferedReader reader, String groupSep) throws IOException {
        return Optional.ofNullable(reader.readLine()).map(l -> l.split(groupSep));
    }

    public String toString() {
        try {
            StringBuilderWriter writer = new StringBuilderWriter();
            this.appendTo((Writer)writer, "\t");
            return writer.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write data", e);
        }
    }

    protected void appendHeader(Writer writer, String groupSep) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(PAGE_HEADER).append(groupSep);
        sb.append(String.join((CharSequence)groupSep, this.groupNames));
        sb.append(groupSep);
        sb.append(ORDER_HEADER);
        sb.append(this.lineSep);
        writer.append(sb.toString());
    }

    protected void appendIndices(Writer writer, String page, List<PagePosition> indices, String groupSep) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (PagePosition index : indices) {
            sb.append(page).append(groupSep);
            for (Object dimension : index.getGroup()) {
                String dimensionStr = this.formatDimension(dimension);
                sb.append(dimensionStr).append(groupSep);
            }
            sb.append(index.getPositionInGroup()).append(this.lineSep);
            writer.append(sb.toString());
            sb.setLength(0);
        }
    }

    public String formatDimension(Object dimension) {
        if (dimension instanceof WikiPageIdentity) {
            return ((WikiPageIdentity)dimension).testSystem();
        }
        return String.valueOf(dimension);
    }
}

