/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner.run;

import fitnesse.testrunner.run.PagePosition;
import fitnesse.testrunner.run.PagePositions;
import fitnesse.testrunner.run.PositionMapBasedWikiPagePartitioner;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PagePositionsBasedWikiPagePartitioner
extends PositionMapBasedWikiPagePartitioner {
    private Comparator<WikiPage> pageComparator;

    public PagePositionsBasedWikiPagePartitioner(PagePositions pagePositions) {
        if (pagePositions != null) {
            this.setPagePositions(pagePositions);
        }
    }

    public void setPagePositions(PagePositions pagePositions) {
        Map<String, Integer> partitionMap = this.loadPartitionFile(pagePositions);
        this.setPartitionMap(partitionMap);
        this.setPageComparator(this.createComparator(pagePositions));
    }

    @Override
    public List<List<WikiPage>> split(List<WikiPage> source, int partitionCount) {
        List<WikiPage> pages = source;
        if (this.pageComparator != null) {
            pages = new ArrayList<WikiPage>(source);
            pages.sort(this.pageComparator);
        }
        return super.split(pages, partitionCount);
    }

    protected Comparator<WikiPage> createComparator(PagePositions pagePositions) {
        Comparator<String> comp = pagePositions.createByPositionInGroupComparator();
        return Comparator.comparing(this::getFullPath, comp);
    }

    protected Map<String, Integer> loadPartitionFile(PagePositions pagePositions) {
        int part = pagePositions.getGroupIndex("Partition");
        if (part < 0) {
            throw new IllegalArgumentException("No Partition column found");
        }
        return this.extractPartitionMap(pagePositions, part);
    }

    protected Map<String, Integer> extractPartitionMap(PagePositions pagePositions, int partGroupIndex) {
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (String page : pagePositions.getPages()) {
            List<PagePosition> positions = pagePositions.getPositions(page);
            for (PagePosition position : positions) {
                Integer partValue = position.getGroupIntValue(partGroupIndex);
                indices.put(page, partValue);
            }
        }
        return indices;
    }

    public Comparator<WikiPage> getPageComparator() {
        return this.pageComparator;
    }

    public void setPageComparator(Comparator<WikiPage> pageComparator) {
        this.pageComparator = pageComparator;
    }
}

