/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner.run;

import fitnesse.testrunner.TestPageWithSuiteSetUpAndTearDown;
import fitnesse.testrunner.WikiPageIdentity;
import fitnesse.testrunner.WikiTestPage;
import fitnesse.testrunner.run.PageListSetUpTearDownInserter;
import fitnesse.testrunner.run.PageListSetUpTearDownProcessor;
import fitnesse.testrunner.run.PageListSetUpTearDownSurrounder;
import fitnesse.testsystems.TestPage;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PagesByTestSystem {
    private final PageListSetUpTearDownProcessor processor;
    private final Map<WikiPageIdentity, List<WikiPage>> pagesByTestSystem;
    private final List<WikiPage> sourcePages;

    public PagesByTestSystem(List<WikiPage> sourcePages) {
        this(PagesByTestSystem.createProcessor(sourcePages), sourcePages);
    }

    public PagesByTestSystem(PageListSetUpTearDownProcessor processor, List<WikiPage> sourcePages) {
        this.sourcePages = sourcePages;
        this.processor = processor;
        Map<WikiPageIdentity, List<WikiPage>> testsPerSystem = PagesByTestSystem.mapWithAllPagesButSuiteSetUpAndTearDown(sourcePages);
        this.pagesByTestSystem = this.addSuiteSetUpAndTearDownToAllTestSystems(testsPerSystem);
    }

    public static PageListSetUpTearDownProcessor createProcessor(List<WikiPage> pages) {
        return pages.isEmpty() || !TestPageWithSuiteSetUpAndTearDown.includeAllSetupsAndTearDowns(pages.get(0)) ? new PageListSetUpTearDownSurrounder() : new PageListSetUpTearDownInserter();
    }

    public static Map<WikiPageIdentity, List<WikiPage>> mapWithAllPagesButSuiteSetUpAndTearDown(List<WikiPage> pages) {
        HashMap<WikiPageIdentity, List<WikiPage>> pagesByTestSystem = new HashMap<WikiPageIdentity, List<WikiPage>>();
        for (WikiPage wikiPage : pages) {
            if (wikiPage.isSuiteSetupOrTearDown()) continue;
            WikiPageIdentity identity = new WikiPageIdentity(wikiPage);
            pagesByTestSystem.computeIfAbsent(identity, i -> new LinkedList()).add(wikiPage);
        }
        return pagesByTestSystem;
    }

    private Map<WikiPageIdentity, List<WikiPage>> addSuiteSetUpAndTearDownToAllTestSystems(Map<WikiPageIdentity, List<WikiPage>> testsPerSystem) {
        HashMap<WikiPageIdentity, List<WikiPage>> orderedPagesByTestSystem = new HashMap<WikiPageIdentity, List<WikiPage>>();
        if (!testsPerSystem.isEmpty()) {
            for (Map.Entry<WikiPageIdentity, List<WikiPage>> entry : testsPerSystem.entrySet()) {
                WikiPageIdentity system = entry.getKey();
                List<WikiPage> testPages = entry.getValue();
                List<WikiPage> allPages = this.processor.addSuiteSetUpsAndTearDowns(testPages);
                orderedPagesByTestSystem.put(system, allPages);
            }
        }
        return orderedPagesByTestSystem;
    }

    private List<TestPage> asTestPages(List<WikiPage> wikiPages) {
        ArrayList<TestPage> testPages = new ArrayList<TestPage>(wikiPages.size());
        for (WikiPage page : wikiPages) {
            testPages.add(new WikiTestPage(page));
        }
        return testPages;
    }

    public List<WikiPage> testsToRun() {
        return this.pagesByTestSystem.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public int totalTestsToRun() {
        return this.pagesByTestSystem.values().stream().mapToInt(List::size).sum();
    }

    public Collection<WikiPageIdentity> identities() {
        return this.pagesByTestSystem.keySet();
    }

    public List<TestPage> testPagesForIdentity(WikiPageIdentity identity) {
        return this.asTestPages(this.pagesByTestSystem.get(identity));
    }

    public List<WikiPage> wikiPagesForIdentity(WikiPageIdentity identity) {
        return Collections.unmodifiableList(this.pagesByTestSystem.get(identity));
    }

    public List<WikiPage> getSourcePages() {
        return this.sourcePages;
    }
}

