/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner.run;

import fitnesse.testrunner.run.PageListPartitioner;
import fitnesse.testrunner.run.PageListPartitionerImpl;
import fitnesse.testrunner.run.PagePositions;
import fitnesse.testrunner.run.PagesByTestSystem;
import fitnesse.testrunner.run.PerTestSystemTestRun;
import fitnesse.testrunner.run.TestRun;
import fitnesse.testrunner.run.TestRunFactory;
import fitnesse.util.partitioner.EqualLengthListPartitioner;
import fitnesse.wiki.WikiPage;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class PartitioningTestRunFactory
implements TestRunFactory {
    public static final String PARTITION_COUNT_ARG = "partitionCount";
    public static final String PARTITION_INDEX_ARG = "partitionIndex";
    private Function<List<WikiPage>, ? extends PagesByTestSystem> factory;
    private Function<List<WikiPage>, PageListPartitioner> partitioner;

    public PartitioningTestRunFactory() {
        this(PagesByTestSystem::new, pages -> new PageListPartitionerImpl(new EqualLengthListPartitioner<WikiPage>()));
    }

    public PartitioningTestRunFactory(Function<List<WikiPage>, ? extends PagesByTestSystem> factory, Function<List<WikiPage>, PageListPartitioner> partitioner) {
        this.factory = factory;
        this.partitioner = partitioner;
    }

    @Override
    public boolean canRun(List<WikiPage> pages) {
        return true;
    }

    @Override
    public TestRun createRun(List<WikiPage> pages) {
        PagesByTestSystem pagesByTestSystem = this.getPagesByTestSystem(pages);
        return this.createRun(pagesByTestSystem);
    }

    @Override
    public PagePositions findPagePositions(List<WikiPage> pages) {
        if (pages.isEmpty()) {
            return new PagePositions();
        }
        WikiPage page = pages.get(0);
        PageListPartitioner pageListPartitioner = this.partitioner.apply(pages);
        int partitionCount = this.getPartitionCount(page);
        return pageListPartitioner.findPagePositions(this.factory, pages, partitionCount);
    }

    protected PagesByTestSystem getPagesByTestSystem(List<WikiPage> pages) {
        if (pages.isEmpty()) {
            return this.factory.apply(pages);
        }
        WikiPage page = pages.get(0);
        PageListPartitioner pageListPartitioner = this.partitioner.apply(pages);
        int partitionCount = this.getPartitionCount(page);
        if (partitionCount == 1) {
            return this.factory.apply(pages);
        }
        int partitionIndex = this.getPartitionIndex(page);
        if (partitionIndex >= partitionCount) {
            throw new IllegalArgumentException("partitionCount must be larger than partitionIndex");
        }
        return pageListPartitioner.partition(this.factory, pages, partitionCount, partitionIndex);
    }

    protected TestRun createRun(PagesByTestSystem pagesByTestSystem) {
        return new PerTestSystemTestRun(pagesByTestSystem);
    }

    protected int getPartitionCount(WikiPage page) {
        int partitionCount = 1;
        String partitionCountStr = page.getVariable(PARTITION_COUNT_ARG);
        if (StringUtils.isNotEmpty((CharSequence)partitionCountStr)) {
            partitionCount = Integer.parseInt(partitionCountStr);
        }
        return partitionCount;
    }

    protected int getPartitionIndex(WikiPage page) {
        int partitionIndex = 0;
        String partitionIndexStr = page.getVariable(PARTITION_INDEX_ARG);
        if (StringUtils.isNotEmpty((CharSequence)partitionIndexStr)) {
            partitionIndex = Integer.parseInt(partitionIndexStr);
        }
        return partitionIndex;
    }

    public Function<List<WikiPage>, ? extends PagesByTestSystem> getFactory() {
        return this.factory;
    }

    public void setFactory(Function<List<WikiPage>, ? extends PagesByTestSystem> factory) {
        this.factory = factory;
    }

    public Function<List<WikiPage>, PageListPartitioner> getPartitioner() {
        return this.partitioner;
    }

    public void setPartitioner(Function<List<WikiPage>, PageListPartitioner> partitioner) {
        this.partitioner = partitioner;
    }
}

