/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner.run;

import fitnesse.testrunner.WikiPageIdentity;
import fitnesse.testrunner.run.PagesByTestSystem;
import fitnesse.testrunner.run.RunCoordinator;
import fitnesse.testrunner.run.TestRun;
import fitnesse.testsystems.TestExecutionException;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSystem;
import fitnesse.wiki.WikiPage;
import java.util.List;

public class PerTestSystemTestRun
implements TestRun {
    private final PagesByTestSystem pagesByTestSystem;
    private TestSystem testSystem;
    private RunCoordinator coordinator;

    public PerTestSystemTestRun(List<WikiPage> pages) {
        this(new PagesByTestSystem(pages));
    }

    public PerTestSystemTestRun(PagesByTestSystem pagesByTestSystem) {
        this.pagesByTestSystem = pagesByTestSystem;
    }

    @Override
    public void executeTestPages(RunCoordinator coordinator) throws TestExecutionException {
        this.coordinator = coordinator;
        coordinator.announceTotalTestsToRun(this.pagesByTestSystem.totalTestsToRun());
        for (WikiPageIdentity identity : this.pagesByTestSystem.identities()) {
            this.startTestSystemAndExecutePages(identity, this.pagesByTestSystem.testPagesForIdentity(identity));
        }
    }

    @Override
    public List<WikiPage> getPages() {
        return this.pagesByTestSystem.testsToRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTestSystemAndExecutePages(WikiPageIdentity identity, List<TestPage> testSystemPages) throws TestExecutionException {
        this.testSystem = null;
        try {
            if (this.coordinator.isNotStopped()) {
                this.testSystem = this.coordinator.startTestSystem(identity, testSystemPages);
            }
            if (this.testSystem != null && this.testSystem.isSuccessfullyStarted()) {
                this.executeTestSystemPages(testSystemPages, this.testSystem);
                this.coordinator.waitForNoTestsInProgress();
            }
        }
        finally {
            if (this.coordinator.isNotStopped() && this.testSystem != null) {
                try {
                    this.testSystem.bye();
                }
                catch (Exception e) {
                    this.coordinator.reportException(e);
                }
            }
        }
    }

    private void executeTestSystemPages(List<TestPage> pagesInTestSystem, TestSystem testSystem) throws TestExecutionException {
        for (TestPage testPage : pagesInTestSystem) {
            this.coordinator.announceTestStarted();
            testSystem.runTests(testPage);
        }
    }

    @Override
    public void stop() {
        if (this.testSystem != null) {
            this.testSystem.kill();
        }
    }
}

