/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner.run;

import fitnesse.FitNesseContext;
import fitnesse.testrunner.run.PagePositions;
import fitnesse.testrunner.run.PartitioningTestRunFactory;
import fitnesse.testrunner.run.TestRun;
import fitnesse.testrunner.run.TestRunFactory;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.List;

public class TestRunFactoryRegistry {
    public static final TestRunFactory DEFAULT = new PartitioningTestRunFactory();
    private final List<TestRunFactory> testRunFactories = new ArrayList<TestRunFactory>();
    private final FitNesseContext context;

    public TestRunFactoryRegistry(FitNesseContext context) {
        this.context = context;
    }

    public void addFactory(TestRunFactory factory) {
        this.testRunFactories.add(0, factory);
    }

    public TestRun createRun(List<WikiPage> pages) {
        return this.getFactory(pages).createRun(pages);
    }

    public PagePositions findPagePositions(List<WikiPage> pages) {
        return this.getFactory(pages).findPagePositions(pages);
    }

    public TestRunFactory getFactory(List<WikiPage> pages) {
        return this.testRunFactories.stream().filter(f -> f.canRun(pages)).findFirst().orElse(DEFAULT);
    }

    public FitNesseContext getContext() {
        return this.context;
    }
}

