/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.fit;

import fitnesse.testsystems.CompositeTestSystemListener;
import fitnesse.testsystems.TestExecutionException;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.UnableToStartException;
import fitnesse.testsystems.UnableToStopException;
import fitnesse.testsystems.fit.CommandRunningFitClient;
import fitnesse.testsystems.fit.FitClientListener;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;

public class FitTestSystem
implements TestSystem,
FitClientListener {
    private static final String EMPTY_PAGE_CONTENT = "OH NO! This page is empty!";
    private final CompositeTestSystemListener testSystemListener;
    private final String testSystemName;
    private final CommandRunningFitClient client;
    private Deque<TestPage> processingQueue = new LinkedList<TestPage>();
    private TestPage currentTestPage;
    private boolean testSystemIsStopped;

    public FitTestSystem(String testSystemName, CommandRunningFitClient fitClient) {
        this.testSystemListener = new CompositeTestSystemListener();
        this.testSystemName = testSystemName;
        this.client = fitClient;
        this.client.addFitClientListener(this);
    }

    @Override
    public String getName() {
        return this.testSystemName;
    }

    @Override
    public void start() throws UnableToStartException {
        try {
            this.client.start();
        }
        catch (IOException e) {
            throw new UnableToStartException("Can not start Fit client", e);
        }
        this.testSystemStarted(this);
    }

    @Override
    public void runTests(TestPage pageToTest) throws TestExecutionException {
        this.processingQueue.addLast(pageToTest);
        String html = pageToTest.getHtml();
        try {
            if (html.isEmpty()) {
                this.client.send(EMPTY_PAGE_CONTENT);
            } else {
                this.client.send(html);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.exceptionOccurred(e);
            throw new TestExecutionException("Testing has been interrupted", e);
        }
        catch (IOException e) {
            this.exceptionOccurred(e);
            throw new TestExecutionException("Communication error during testing", e);
        }
    }

    @Override
    public void bye() throws UnableToStopException {
        try {
            this.client.done();
            this.client.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UnableToStopException("Unable to stop Fit client", e);
        }
        catch (IOException e) {
            throw new UnableToStopException("Unable to stop Fit client", e);
        }
        finally {
            this.testSystemStopped(null);
        }
    }

    @Override
    public void kill() {
        this.client.kill();
    }

    @Override
    public void addTestSystemListener(TestSystemListener listener) {
        this.testSystemListener.addTestSystemListener(listener);
    }

    @Override
    public void testOutputChunk(String output) {
        if (this.currentTestPage == null) {
            this.currentTestPage = this.processingQueue.removeFirst();
            this.testSystemListener.testStarted(this.currentTestPage);
        }
        this.testSystemListener.testOutputChunk(this.currentTestPage, output);
    }

    @Override
    public void testComplete(TestSummary testSummary) {
        assert (this.currentTestPage != null);
        try {
            this.testSystemListener.testComplete(this.currentTestPage, testSummary);
        }
        finally {
            this.currentTestPage = null;
        }
    }

    @Override
    public void exceptionOccurred(Throwable t) {
        try {
            this.client.kill();
        }
        finally {
            this.testSystemStopped(t);
        }
    }

    private void testSystemStarted(TestSystem testSystem) {
        this.testSystemListener.testSystemStarted(testSystem);
    }

    private void testSystemStopped(Throwable throwable) {
        if (this.testSystemIsStopped) {
            return;
        }
        this.testSystemIsStopped = true;
        this.testSystemListener.testSystemStopped(this, throwable);
    }

    @Override
    public boolean isSuccessfullyStarted() {
        return this.client.isSuccessfullyStarted();
    }
}

