/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.fit;

import fitnesse.testsystems.Descriptor;
import fitnesse.testsystems.fit.CommandRunningFitClient;
import fitnesse.testsystems.fit.FitClientBuilder;
import java.lang.reflect.Method;

public class InProcessFitClientBuilder
extends FitClientBuilder {
    private final ClassLoader classLoader;

    public InProcessFitClientBuilder(Descriptor descriptor, ClassLoader classLoader) {
        super(descriptor);
        this.classLoader = classLoader;
    }

    @Override
    public CommandRunningFitClient build() {
        Method testRunnerMethod = this.getTestRunnerMainMethod();
        CommandRunningFitClient.InProcessCommandRunner runningStrategy = new CommandRunningFitClient.InProcessCommandRunner(testRunnerMethod, this.getExecutionLogListener(), this.classLoader);
        return this.buildFitClient(runningStrategy);
    }

    protected Method getTestRunnerMainMethod() {
        try {
            Class<?> testRunnerClass = this.classLoader.loadClass(this.getTestRunner());
            return testRunnerClass.getDeclaredMethod("main", String[].class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Can not find test runner main", e);
        }
    }
}

