/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import difflib.Chunk;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import fitnesse.html.HtmlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HtmlDiffUtil {
    public static String buildActual(String actual, String expected) {
        return new ActualBuilder(actual, expected).build();
    }

    public static String buildExpected(String actual, String expected) {
        return new ExpectedBuilder(actual, expected).build();
    }

    public static class ExpectedBuilder
    extends Builder {
        public ExpectedBuilder(String actual, String expected) {
            super(actual, expected);
            this.text = this.stringToCharacterList(expected);
        }

        @Override
        protected Chunk<Character> getChunk(Delta<Character> d) {
            return d.getRevised();
        }
    }

    public static class ActualBuilder
    extends Builder {
        public ActualBuilder(String actual, String expected) {
            super(actual, expected);
            this.text = this.stringToCharacterList(actual);
        }

        @Override
        protected Chunk<Character> getChunk(Delta<Character> d) {
            return d.getOriginal();
        }
    }

    public static abstract class Builder {
        List<Character> text;
        final Patch<Character> patch;
        final StringBuilder stringBuilder = new StringBuilder();
        boolean isInDiffArea = false;
        String openingTag = "<span class=\"diff\">";
        String closingTag = "</span>";

        protected Builder(String actual, String expected) {
            this.patch = DiffUtils.diff(this.stringToCharacterList(actual), this.stringToCharacterList(expected));
        }

        public Builder setOpeningTag(String openingTag) {
            this.openingTag = openingTag;
            return this;
        }

        public Builder setClosingTag(String closingTag) {
            this.closingTag = closingTag;
            return this;
        }

        public String build() {
            for (int i = 0; i < this.getText().size(); ++i) {
                this.addElementToStringBuilder(i);
            }
            return this.stringBuilder.toString();
        }

        protected abstract Chunk<Character> getChunk(Delta<Character> var1);

        private void addElementToStringBuilder(int i) {
            Delta<Character> delta = this.getDeltaByIndex(i, this.patch);
            this.addOpeningTagIfDeltaAtFirstElement(i, delta);
            this.addTagIfDeltaSwitching(delta);
            this.addCharacterFromDeltaOrText(i, delta);
            this.addClosingTagIfDeltaAtLastElement(i, delta);
        }

        private void addCharacterFromDeltaOrText(int i, Delta<Character> delta) {
            if (delta == null) {
                this.stringBuilder.append(HtmlUtil.escapeHTML(this.getText().get(i).toString()));
            } else {
                this.stringBuilder.append(HtmlUtil.escapeHTML(this.getFromChunkByIndex(this.getChunk(delta), i).toString()));
            }
        }

        private void addTagIfDeltaSwitching(Delta<Character> delta) {
            if (delta == null) {
                if (this.isInDiffArea) {
                    this.addClosingTag();
                }
            } else if (!this.isInDiffArea) {
                this.addOpeningTag();
            }
        }

        private void addClosingTagIfDeltaAtLastElement(int i, Delta<Character> delta) {
            if (delta != null && this.isLastElement(i)) {
                this.addClosingTag();
            }
        }

        private void addClosingTag() {
            this.isInDiffArea = false;
            this.stringBuilder.append(this.closingTag);
        }

        private void addOpeningTagIfDeltaAtFirstElement(int i, Delta<Character> delta) {
            if (delta != null && this.isFirstElement(i)) {
                this.addOpeningTag();
            }
        }

        private void addOpeningTag() {
            this.isInDiffArea = true;
            this.stringBuilder.append(this.openingTag);
        }

        private Delta<Character> getDeltaByIndex(int i, Patch<Character> patch) {
            for (Delta delta : patch.getDeltas()) {
                if (!this.isInChunk(this.getChunk((Delta<Character>)delta), i)) continue;
                return delta;
            }
            return null;
        }

        private boolean isInChunk(Chunk<Character> chunk, int i) {
            return i >= chunk.getPosition() && i < chunk.getPosition() + chunk.size();
        }

        private Character getFromChunkByIndex(Chunk<Character> chunk, int i) {
            int j = i - chunk.getPosition();
            return (Character)chunk.getLines().get(j);
        }

        private List<Character> getText() {
            return this.text;
        }

        private boolean isFirstElement(int i) {
            return i == 0;
        }

        private boolean isLastElement(int i) {
            return i == this.getText().size() - 1;
        }

        protected List<Character> stringToCharacterList(String s) {
            if (s == null || s.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Character> characterList = new ArrayList<Character>(s.length());
            for (char c : s.toCharArray()) {
                characterList.add(Character.valueOf(c));
            }
            return characterList;
        }
    }
}

