/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.slim.SlimServer;
import fitnesse.slim.SlimStreamReader;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.protocol.SlimDeserializer;
import fitnesse.slim.protocol.SlimListBuilder;
import fitnesse.slim.protocol.SlimSerializer;
import fitnesse.testsystems.ExecutionLogListener;
import fitnesse.testsystems.slim.SlimClient;
import fitnesse.testsystems.slim.SlimCommandRunningClient;
import fitnesse.testsystems.slim.SlimCommunicationException;
import fitnesse.testsystems.slim.SlimVersionMismatch;
import fitnesse.util.MockSocket;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class InProcessSlimClient
implements SlimClient {
    private final String testSystemName;
    private final SlimServer slimServer;
    private final ExecutionLogListener executionLogListener;
    private ClassLoader classLoader;
    private MockSocket socket;
    private PipedOutputStream clientOutput;
    private Thread slimServerThread;
    private SlimStreamReader reader;
    private double slimServerVersion;

    public InProcessSlimClient(String testSystemName, SlimServer slimServer, ExecutionLogListener executionLogListener, ClassLoader classLoader) {
        this.testSystemName = testSystemName;
        this.slimServer = slimServer;
        this.executionLogListener = executionLogListener;
        this.classLoader = classLoader;
    }

    @Override
    public void start() throws IOException, SlimVersionMismatch {
        this.commandStarted();
        PipedInputStream socketInput = new PipedInputStream();
        this.clientOutput = new PipedOutputStream(socketInput);
        PipedInputStream clientInput = new PipedInputStream();
        PipedOutputStream socketOutput = new PipedOutputStream(clientInput);
        this.reader = new SlimStreamReader(clientInput);
        this.socket = new MockSocket(socketInput, socketOutput);
        this.slimServerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    InProcessSlimClient.this.slimServer.serve(InProcessSlimClient.this.socket);
                    InProcessSlimClient.this.executionLogListener.exitCode(0);
                }
                catch (Throwable t) {
                    InProcessSlimClient.this.executionLogListener.exceptionOccurred(t);
                }
            }
        });
        this.slimServerThread.setContextClassLoader(this.classLoader);
        this.slimServerThread.start();
        this.connect();
    }

    private void commandStarted() {
        this.executionLogListener.commandStarted(new ExecutionLogListener.ExecutionContext(){

            @Override
            public String getCommand() {
                return "";
            }

            @Override
            public String getTestSystemName() {
                return InProcessSlimClient.this.testSystemName;
            }
        });
    }

    @Override
    public Map<String, Object> invokeAndGetResponse(List<Instruction> statements) throws SlimCommunicationException {
        String results;
        if (statements.isEmpty()) {
            return Collections.emptyMap();
        }
        String instructions = SlimSerializer.serialize(new SlimListBuilder(this.slimServerVersion).toList(statements));
        try {
            SlimStreamReader.sendSlimMessage(this.clientOutput, instructions);
            results = this.reader.getSlimMessage();
        }
        catch (IOException e) {
            throw new SlimCommunicationException("Could not send/receive data with SUT", e);
        }
        List<Object> resultList = SlimDeserializer.deserialize(results);
        return SlimCommandRunningClient.resultToMap(resultList);
    }

    @Override
    public void connect() throws IOException, SlimVersionMismatch {
        String slimServerVersionMessage = this.reader.readLine();
        if (!this.isConnected(slimServerVersionMessage)) {
            throw new SlimVersionMismatch("Got invalid slim header from client. Read the following: " + slimServerVersionMessage);
        }
        this.slimServerVersion = Double.parseDouble(slimServerVersionMessage.replace("Slim -- V", ""));
        if (this.slimServerVersion == -32000.0) {
            throw new SlimVersionMismatch("Slim Protocol Version Error: Server did not respond with a valid version number.");
        }
        if (this.slimServerVersion < SlimCommandRunningClient.MINIMUM_REQUIRED_SLIM_VERSION) {
            throw new SlimVersionMismatch(String.format("Slim Protocol Version Error: Expected V%s but was V%s", SlimCommandRunningClient.MINIMUM_REQUIRED_SLIM_VERSION, this.slimServerVersion));
        }
    }

    public boolean isConnected(String slimServerVersionMessage) {
        return slimServerVersionMessage.startsWith("Slim -- V");
    }

    @Override
    public void bye() throws IOException {
        if (this.slimServerThread.isAlive()) {
            SlimStreamReader.sendSlimMessage(this.clientOutput, "bye");
        }
    }

    @Override
    public void kill() {
        this.slimServerThread.interrupt();
    }
}

