/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.slim.JavaSlimFactory;
import fitnesse.slim.SlimServer;
import fitnesse.slim.SlimService;
import fitnesse.slim.fixtureInteraction.FixtureInteraction;
import fitnesse.testsystems.ClientBuilder;
import fitnesse.testsystems.Descriptor;
import fitnesse.testsystems.slim.InProcessSlimClient;
import fitnesse.testsystems.slim.SlimClient;

public class InProcessSlimClientBuilder
extends ClientBuilder<SlimClient> {
    private ClassLoader classLoader;

    public InProcessSlimClientBuilder(Descriptor descriptor, ClassLoader classLoader) {
        super(descriptor);
        this.classLoader = classLoader;
    }

    @Override
    public SlimClient build() {
        SlimService.Options options = SlimService.parseCommandLine(this.getSlimFlags());
        Integer statementTimeout = options != null ? options.statementTimeout : null;
        FixtureInteraction interaction = options != null ? options.interaction : JavaSlimFactory.createInteraction(null, this.classLoader);
        SlimServer slimServer = this.createSlimServer(interaction, statementTimeout, this.isDebug());
        return new InProcessSlimClient(this.getTestSystemName(), slimServer, this.getExecutionLogListener(), this.classLoader);
    }

    @Override
    protected String defaultTestRunner() {
        return "in-process";
    }

    protected SlimServer createSlimServer(FixtureInteraction interaction, Integer timeout, boolean verbose) {
        return JavaSlimFactory.createJavaSlimFactory(interaction, timeout, verbose).getSlimServer();
    }

    protected String[] getSlimFlags() {
        String slimFlags = this.getVariable("slim.flags");
        if (slimFlags == null) {
            slimFlags = this.getVariable("SLIM_FLAGS");
        }
        return slimFlags == null ? new String[]{} : this.parseCommandLine(slimFlags);
    }
}

