/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.socketservice.ClientSocketFactory;
import fitnesse.socketservice.PlainClientSocketFactory;
import fitnesse.socketservice.PlainServerSocketFactory;
import fitnesse.socketservice.SslClientSocketFactory;
import fitnesse.socketservice.SslParameters;
import fitnesse.testsystems.ClientBuilder;
import fitnesse.testsystems.CommandRunner;
import fitnesse.testsystems.Descriptor;
import fitnesse.testsystems.ExecutionLogListener;
import fitnesse.testsystems.MockCommandRunner;
import fitnesse.testsystems.slim.PipeBasedSocketFactory;
import fitnesse.testsystems.slim.SlimCommandRunningClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;

public class SlimClientBuilder
extends ClientBuilder<SlimCommandRunningClient> {
    public static final String SLIM_PORT = "SLIM_PORT";
    public static final String SLIM_HOST = "SLIM_HOST";
    public static final String SLIM_FLAGS = "SLIM_FLAGS";
    private static final String SLIM_VERSION = "SLIM_VERSION";
    public static final String MANUALLY_START_TEST_RUNNER_ON_DEBUG = "MANUALLY_START_TEST_RUNNER_ON_DEBUG";
    public static final String MANUALLY_START_TEST_RUNNER = "MANUALLY_START_TEST_RUNNER";
    public static final String SLIM_SSL = "SLIM_SSL";
    public static final int SLIM_USE_PIPE_PORT = 1;
    private static final AtomicInteger slimPortOffset = new AtomicInteger(0);
    private int slimPort = this.getNextSlimPort();

    public SlimClientBuilder(Descriptor descriptor) {
        super(descriptor);
    }

    @Override
    public SlimCommandRunningClient build() {
        CommandRunner commandRunner = this.determineCommandRunner();
        return new SlimCommandRunningClient(commandRunner, this.determineSlimHost(), this.getSlimPort(), this.determineTimeout(), this.getSlimVersion(), this.determineSocketFactory(commandRunner));
    }

    protected CommandRunner determineCommandRunner() {
        if (this.getSlimPort() == 1) {
            return new CommandRunner(this.buildCommand(), this.createClasspathEnvironment(this.getClassPath()), this.getExecutionLogListener(), this.determineTimeout()){

                @Override
                protected void redirectOutputs(Process process, final ExecutionLogListener executionLogListener) throws IOException {
                    InputStream stderr = process.getErrorStream();
                    new Thread((Runnable)new CommandRunner.OutputReadingRunnable(this, stderr, new CommandRunner.OutputWriter(){

                        @Override
                        public void write(String output) {
                            String originalMsg = this.extractOriginalMessage(output, "SOUT");
                            if (originalMsg != null) {
                                executionLogListener.stdOut(originalMsg);
                            } else {
                                originalMsg = this.extractOriginalMessage(output, "SERR");
                                if (originalMsg != null) {
                                    executionLogListener.stdErr(originalMsg);
                                    this.setCommandErrorMessage(originalMsg);
                                } else {
                                    executionLogListener.stdOut(output);
                                }
                            }
                        }

                        private String extractOriginalMessage(String prefixedMessage, String level) {
                            if (prefixedMessage.startsWith(level)) {
                                return prefixedMessage.substring(level.length() + " :".length());
                            }
                            return null;
                        }
                    }), "CommandRunner stdOutErr").start();
                }
            };
        }
        if (this.useManualStartForTestSystem()) {
            return new MockCommandRunner("Connection to running SlimService: " + this.determineSlimHost() + ":" + this.getSlimPort(), this.getExecutionLogListener(), this.determineTimeout());
        }
        return new CommandRunner(this.buildCommand(), this.createClasspathEnvironment(this.getClassPath()), this.getExecutionLogListener(), this.determineTimeout());
    }

    protected ClientSocketFactory determineSocketFactory(CommandRunner commandRunner) {
        if (this.getSlimPort() == 1) {
            return new PipeBasedSocketFactory(commandRunner);
        }
        if (this.determineClientSSLParameterClass() != null) {
            return new SslClientSocketFactory(this.determineHostSSLParameters());
        }
        return new PlainClientSocketFactory();
    }

    protected String determineClientSSLParameterClass() {
        String sslParameterClassName = this.getVariable("slim.ssl");
        if (sslParameterClassName == null) {
            sslParameterClassName = this.getVariable(SLIM_SSL);
        }
        if (sslParameterClassName != null && sslParameterClassName.equalsIgnoreCase("false")) {
            sslParameterClassName = null;
        }
        return sslParameterClassName;
    }

    protected SslParameters determineHostSSLParameters() {
        String val = this.getVariable("wiki.protocol.ssl.parameter.class");
        return SslParameters.createSslParameters(val);
    }

    public double getSlimVersion() {
        double version = SlimCommandRunningClient.MINIMUM_REQUIRED_SLIM_VERSION;
        try {
            String slimVersion = this.getVariable(SLIM_VERSION);
            if (slimVersion != null) {
                version = Double.valueOf(slimVersion);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version;
    }

    @Override
    protected String defaultTestRunner() {
        return "fitnesse.slim.SlimService";
    }

    protected String[] buildCommand() {
        Object[] slimArguments = this.buildArguments();
        Object[] slimCommandPrefix = super.buildCommand(this.getCommandPattern(), this.getTestRunner(), this.getClassPath());
        return (String[])ArrayUtils.addAll((Object[])slimCommandPrefix, (Object[])slimArguments);
    }

    protected String[] buildArguments() {
        String[] slimFlags;
        Object[] arguments = new String[]{};
        String useSSL = this.determineClientSSLParameterClass();
        if (useSSL != null) {
            arguments = (String[])ArrayUtils.add((Object[])arguments, (Object)"-ssl");
            arguments = (String[])ArrayUtils.add((Object[])arguments, (Object)useSSL);
        }
        if ((slimFlags = this.getSlimFlags()) != null) {
            for (String flag : slimFlags) {
                arguments = (String[])ArrayUtils.add((Object[])arguments, (Object)flag);
            }
        }
        arguments = (String[])ArrayUtils.add((Object[])arguments, (Object)Integer.toString(this.getSlimPort()));
        return arguments;
    }

    public int getSlimPort() {
        return this.slimPort;
    }

    protected void setSlimPort(int slimPort) {
        this.slimPort = slimPort;
    }

    private int findFreePort() {
        int port;
        try {
            ServerSocket socket = new PlainServerSocketFactory().createServerSocket(0);
            port = socket.getLocalPort();
            socket.close();
        }
        catch (Exception e) {
            port = -1;
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextSlimPort() {
        int base = this.getSlimPortBase();
        int poolSize = this.getSlimPortPoolSize();
        if (base == 0) {
            return this.findFreePort();
        }
        if (base == 1) {
            return 1;
        }
        Class<SlimClientBuilder> clazz = SlimClientBuilder.class;
        synchronized (SlimClientBuilder.class) {
            int offset = slimPortOffset.get();
            int port = offset + base;
            offset = (offset + 1) % poolSize;
            slimPortOffset.set(offset);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return port;
        }
    }

    public static void clearSlimPortOffset() {
        slimPortOffset.set(0);
    }

    private int getSlimPortBase() {
        try {
            String port = this.getVariable("slim.port");
            if (port == null) {
                port = this.getVariable(SLIM_PORT);
            }
            if (port != null) {
                return Integer.parseInt(port);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 1;
    }

    private int getSlimPortPoolSize() {
        try {
            String poolSize = this.getVariable("slim.pool.size");
            if (poolSize != null) {
                return Integer.parseInt(poolSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 10;
    }

    protected String determineSlimHost() {
        String slimHost = this.getVariable("slim.host");
        if (slimHost == null) {
            slimHost = this.getVariable(SLIM_HOST);
        }
        return slimHost == null ? "localhost" : slimHost;
    }

    protected String[] getSlimFlags() {
        String slimFlags = this.getVariable("slim.flags");
        if (slimFlags == null) {
            slimFlags = this.getVariable(SLIM_FLAGS);
        }
        return slimFlags == null ? new String[]{} : this.parseCommandLine(slimFlags);
    }

    protected int determineTimeout() {
        if (this.isDebug()) {
            try {
                String debugTimeout = this.getVariable("slim.debug.timeout");
                if (debugTimeout != null) {
                    return Integer.parseInt(debugTimeout);
                }
            }
            catch (NumberFormatException debugTimeout) {
                // empty catch block
            }
        }
        try {
            String timeout = this.getVariable("slim.timeout");
            if (timeout != null) {
                return Integer.parseInt(timeout);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 10;
    }

    private boolean useManualStartForTestSystem() {
        String useManualStart;
        if (this.isDebug()) {
            useManualStart = this.getVariable("manually.start.test.runner.on.debug");
            if (useManualStart == null) {
                useManualStart = this.getVariable(MANUALLY_START_TEST_RUNNER_ON_DEBUG);
            }
            if (useManualStart != null) {
                return "true".equalsIgnoreCase(useManualStart);
            }
        }
        if ((useManualStart = this.getVariable("manually.start.test.runner")) == null) {
            useManualStart = this.getVariable(MANUALLY_START_TEST_RUNNER);
        }
        return "true".equalsIgnoreCase(useManualStart);
    }
}

