/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.slim.SlimError;
import fitnesse.slim.SlimStreamReader;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.protocol.SlimDeserializer;
import fitnesse.slim.protocol.SlimListBuilder;
import fitnesse.slim.protocol.SlimSerializer;
import fitnesse.socketservice.ClientSocketFactory;
import fitnesse.testsystems.CommandRunner;
import fitnesse.testsystems.slim.SlimClient;
import fitnesse.testsystems.slim.SlimCommunicationException;
import fitnesse.testsystems.slim.SlimVersionMismatch;
import fitnesse.util.Clock;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import util.FileUtil;

public class SlimCommandRunningClient
implements SlimClient {
    private static final Logger LOG = Logger.getLogger(SlimCommandRunningClient.class.getName());
    public static final int NO_SLIM_SERVER_CONNECTION_FLAG = -32000;
    public static double MINIMUM_REQUIRED_SLIM_VERSION = 0.3;
    protected final CommandRunner slimRunner;
    private final int connectionTimeout;
    private final double requiredSlimVersion;
    private final ClientSocketFactory clientSocketFactory;
    private Socket client;
    protected SlimStreamReader reader;
    protected OutputStream writer;
    private String slimServerVersionMessage;
    private double slimServerVersion;
    private String hostName;
    private int port;

    public SlimCommandRunningClient(CommandRunner slimRunner, String hostName, int port, int connectionTimeout, double requiredSlimVersion, ClientSocketFactory clientSocketFactory) {
        this.slimRunner = slimRunner;
        this.hostName = hostName;
        this.port = port;
        this.connectionTimeout = connectionTimeout;
        this.requiredSlimVersion = requiredSlimVersion;
        this.clientSocketFactory = clientSocketFactory;
    }

    @Override
    public void start() throws IOException, SlimVersionMismatch {
        try {
            this.slimRunner.asynchronousStart();
        }
        catch (Exception e) {
            String slimErrorMessage = "Error SLiM server startup failed. " + this.slimRunner.getCommandErrorMessage();
            throw new SlimError(slimErrorMessage, e);
        }
        this.connect();
        this.checkForVersionMismatch();
    }

    private void checkForVersionMismatch() throws SlimVersionMismatch {
        double serverVersionNumber = this.getServerVersion();
        if (serverVersionNumber == -32000.0) {
            throw new SlimVersionMismatch("Slim Protocol Version Error: Server did not respond with a valid version number.");
        }
        if (serverVersionNumber < this.requiredSlimVersion) {
            throw new SlimVersionMismatch(String.format("Slim Protocol Version Error: Expected V%s but was V%s", this.requiredSlimVersion, serverVersionNumber));
        }
    }

    @Override
    public void kill() {
        if (this.slimRunner != null) {
            this.slimRunner.kill();
        }
        FileUtil.close(this.reader);
        FileUtil.close(this.writer);
        FileUtil.close(this.client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        int sleepStep = 50;
        long timeOut = Clock.currentTimeInMillis() + (long)(this.connectionTimeout * 1000);
        LOG.finest("Trying to connect to host: " + this.hostName + " on port: " + this.port + " timeout setting: " + this.connectionTimeout);
        while (this.client == null) {
            if (this.slimRunner != null && this.slimRunner.isDead()) {
                String slimErrorMessage = "Error SLiM server died before a connection could be established. " + this.slimRunner.getCommandErrorMessage();
                throw new SlimError(slimErrorMessage);
            }
            try {
                this.client = this.clientSocketFactory.createSocket(this.hostName, this.port);
            }
            catch (IOException e) {
                if (Clock.currentTimeInMillis() > timeOut) {
                    throw new SlimError("Error connecting to SLiM server on " + this.hostName + ":" + this.port, e);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        LOG.fine("Connected to host: " + this.hostName + " on port: " + this.port + " timeout setting: " + this.connectionTimeout);
        this.reader = SlimStreamReader.getReader(this.client);
        this.writer = SlimStreamReader.getByteWriter(this.client);
        int waittime = this.connectionTimeout * 1000;
        int oldTimeout = this.client.getSoTimeout();
        this.client.setSoTimeout(waittime);
        try {
            this.validateConnection();
        }
        finally {
            this.client.setSoTimeout(oldTimeout);
        }
    }

    protected void validateConnection() throws IOException {
        long timeOut = Clock.currentTimeInMillis() + (long)(this.connectionTimeout * 1000);
        LOG.finest("Trying to get SlimHeader:  timeout setting: " + this.connectionTimeout);
        while (!this.isConnected()) {
            if (this.slimRunner != null && this.slimRunner.isDead()) {
                String slimErrorMessage = "Error SLiM server died before Header Message could be read. " + this.slimRunner.getCommandErrorMessage();
                throw new SlimError(slimErrorMessage);
            }
            if (Clock.currentTimeInMillis() > timeOut) {
                throw new SlimError("Timeout while reading slim header from client. Check that you are connecting to the right port and that the slim client is running. You can increase the timeout limit by setting 'slim.timeout' in the fitnesse properties file.");
            }
            try {
                this.slimServerVersionMessage = this.reader.readLine();
            }
            catch (SocketTimeoutException e) {
                throw new SlimError("Timeout while reading slim header from client. Check that you are connecting to the right port and that the slim client is running. You can increase the timeout limit by setting 'slim.timeout' in the fitnesse properties file.");
            }
            LOG.finest("Read Slim Header: >" + this.slimServerVersionMessage + "<");
        }
        try {
            this.slimServerVersion = Double.parseDouble(this.slimServerVersionMessage.replace("Slim -- V", ""));
        }
        catch (Exception e) {
            this.slimServerVersion = -32000.0;
            throw new SlimError("Got invalid slim version from Client. Read the following: " + this.slimServerVersionMessage);
        }
        LOG.fine("Got Slim Header: " + this.slimServerVersionMessage + ", and Version " + this.slimServerVersion);
    }

    public double getServerVersion() {
        return this.slimServerVersion;
    }

    public boolean isConnected() {
        return this.slimServerVersionMessage != null && this.slimServerVersionMessage.startsWith("Slim -- V");
    }

    @Override
    public Map<String, Object> invokeAndGetResponse(List<Instruction> statements) throws SlimCommunicationException {
        String results;
        if (statements.isEmpty()) {
            return Collections.emptyMap();
        }
        String instructions = SlimSerializer.serialize(new SlimListBuilder(this.slimServerVersion).toList(statements));
        try {
            SlimStreamReader.sendSlimMessage(this.writer, instructions);
            results = this.reader.getSlimMessage();
        }
        catch (IOException e) {
            throw new SlimCommunicationException("Could not send/receive data with SUT", e);
        }
        List<Object> resultList = SlimDeserializer.deserialize(results);
        return SlimCommandRunningClient.resultToMap(resultList);
    }

    @Override
    public void bye() throws IOException {
        SlimStreamReader.sendSlimMessage(this.writer, "bye");
        this.slimRunner.join();
        this.kill();
    }

    public static Map<String, Object> resultToMap(List<?> slimResults) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object aResult : slimResults) {
            List resultList = (List)aResult;
            map.put((String)resultList.get(0), resultList.get(1));
        }
        return map;
    }
}

