/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.slim.instructions.AssignInstruction;
import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.Assertion;
import fitnesse.testsystems.CompositeTestSystemListener;
import fitnesse.testsystems.ExceptionResult;
import fitnesse.testsystems.TestExecutionException;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.UnableToStartException;
import fitnesse.testsystems.UnableToStopException;
import fitnesse.testsystems.slim.SlimClient;
import fitnesse.testsystems.slim.SlimCommunicationException;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.SlimTestContextImpl;
import fitnesse.testsystems.slim.SlimVersionMismatch;
import fitnesse.testsystems.slim.results.SlimExceptionResult;
import fitnesse.testsystems.slim.tables.SlimAssertion;
import fitnesse.testsystems.slim.tables.SlimTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class SlimTestSystem
implements TestSystem {
    private final SlimClient slimClient;
    private final CompositeTestSystemListener testSystemListener;
    private final String testSystemName;
    private SlimTestContextImpl testContext;
    boolean stopTestCalled;
    private boolean stopSuiteCalled;
    private boolean testSystemIsStopped;

    public SlimTestSystem(String testSystemName, SlimClient slimClient) {
        this.testSystemName = testSystemName;
        this.slimClient = slimClient;
        this.testSystemListener = new CompositeTestSystemListener();
    }

    public SlimTestContext getTestContext() {
        return this.testContext;
    }

    @Override
    public String getName() {
        return this.testSystemName;
    }

    @Override
    public boolean isSuccessfullyStarted() {
        return !this.testSystemIsStopped;
    }

    @Override
    public void start() throws UnableToStartException {
        try {
            this.slimClient.start();
        }
        catch (SlimVersionMismatch slimVersionMismatch) {
            this.stopTestSystem(slimVersionMismatch);
            return;
        }
        catch (IOException e) {
            this.stopTestSystem(e);
            throw new UnableToStartException("Could not start test system", e);
        }
        catch (Exception e) {
            this.stopTestSystem(e);
            throw e;
        }
        this.testSystemListener.testSystemStarted(this);
    }

    @Override
    public void kill() {
        this.slimClient.kill();
    }

    @Override
    public void bye() throws UnableToStopException {
        if (this.testSystemIsStopped) {
            return;
        }
        try {
            this.slimClient.bye();
            this.testSystemStopped(null);
        }
        catch (IOException e) {
            this.stopTestSystem(e);
            throw new UnableToStopException("Could not stop test system", e);
        }
    }

    @Override
    public void runTests(TestPage pageToTest) throws TestExecutionException {
        this.initializeTest(pageToTest);
        this.testStarted(pageToTest);
        try {
            this.processAllTablesOnPage(pageToTest);
            this.testComplete(pageToTest, this.testContext.getTestSummary());
        }
        catch (Exception e) {
            this.stopTestSystem(e);
            throw new TestExecutionException(e);
        }
    }

    @Override
    public void addTestSystemListener(TestSystemListener listener) {
        this.testSystemListener.addTestSystemListener(listener);
    }

    protected void initializeTest(TestPage testPage) {
        this.testContext = this.createTestContext(testPage);
        this.stopTestCalled = false;
    }

    protected SlimTestContextImpl createTestContext(TestPage testPage) {
        return new SlimTestContextImpl(testPage);
    }

    protected abstract void processAllTablesOnPage(TestPage var1) throws TestExecutionException;

    protected void processTable(SlimTable table, boolean isSuiteTearDownPage) throws TestExecutionException {
        Map<String, Object> instructionResults;
        List<SlimAssertion> assertions = table.getAssertions();
        if (this.stopTestCalled && !table.isTearDown()) {
            instructionResults = Collections.emptyMap();
        } else {
            boolean tearDownOfAlreadyStartedTest = this.stopTestCalled && table.isTearDown();
            instructionResults = this.stopSuiteCalled && !isSuiteTearDownPage && !tearDownOfAlreadyStartedTest ? Collections.emptyMap() : this.slimClient.invokeAndGetResponse(SlimAssertion.getInstructions(assertions));
        }
        this.evaluateTables(assertions, instructionResults);
    }

    protected void evaluateTables(List<SlimAssertion> assertions, Map<String, Object> instructionResults) throws SlimCommunicationException {
        for (SlimAssertion a : assertions) {
            Map<String, ?> variables;
            String key = a.getInstruction().getId();
            Object returnValue = instructionResults.get(key);
            if (returnValue != null && returnValue instanceof String && ((String)returnValue).startsWith("__EXCEPTION__:")) {
                SlimExceptionResult exceptionResult = new SlimExceptionResult(key, (String)returnValue);
                if (exceptionResult.isStopTestException()) {
                    this.stopTestCalled = true;
                    this.stopSuiteCalled = "SuiteSetUp".equals(this.testContext.getPageToTest().getName());
                }
                if (exceptionResult.isStopSuiteException()) {
                    this.stopSuiteCalled = true;
                    this.stopTestCalled = true;
                }
                if ((exceptionResult = a.getExpectation().evaluateException(exceptionResult)) == null) continue;
                if (!exceptionResult.isCatchException()) {
                    this.testExceptionOccurred(a, exceptionResult);
                    continue;
                }
                this.testAssertionVerified(a, exceptionResult.catchTestResult());
                continue;
            }
            TestResult testResult = a.getExpectation().evaluateExpectation(returnValue);
            this.testAssertionVerified(a, testResult);
            if (testResult == null || (variables = testResult.getVariablesToStore()) == null) continue;
            ArrayList<Instruction> instructions = new ArrayList<Instruction>(variables.size());
            int i = 0;
            for (Map.Entry<String, ?> variable : variables.entrySet()) {
                instructions.add(new AssignInstruction("assign_" + i++, variable.getKey(), variable.getValue()));
            }
            if (i <= 0) continue;
            this.slimClient.invokeAndGetResponse(instructions);
        }
    }

    protected void testOutputChunk(TestPage testPage, String output) {
        this.testSystemListener.testOutputChunk(testPage, output);
    }

    protected void testStarted(TestPage testPage) {
        this.testSystemListener.testStarted(testPage);
    }

    protected void testComplete(TestPage testPage, TestSummary testSummary) {
        this.testSystemListener.testComplete(testPage, testSummary);
    }

    protected void stopTestSystem(Throwable e) {
        this.slimClient.kill();
        this.testSystemStopped(e);
    }

    protected void testAssertionVerified(Assertion assertion, TestResult testResult) {
        this.testSystemListener.testAssertionVerified(assertion, testResult);
    }

    protected void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
        this.testSystemListener.testExceptionOccurred(assertion, exceptionResult);
    }

    protected void testSystemStopped(Throwable e) {
        if (this.testSystemIsStopped) {
            return;
        }
        this.testSystemIsStopped = true;
        this.testSystemListener.testSystemStopped(this, e);
    }
}

