/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.slim.tables.MethodExtractorResult;
import fitnesse.testsystems.slim.tables.MethodExtractorRule;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.json.JSONArray;
import org.json.JSONObject;

public class MethodExtractor {
    private final String version = "1.0";
    private final List<MethodExtractorRule> configurations = new ArrayList<MethodExtractorRule>();

    public MethodExtractor() {
    }

    public MethodExtractor(String configString) {
        JSONObject jo = new JSONObject(configString);
        String fV = jo.getString("FormatVersion");
        if (!"1.0".equals(fV)) {
            throw new IllegalArgumentException("JSON Mesage has version '" + fV + "'. This class expects version '" + "1.0" + "'.");
        }
        JSONArray configList = jo.getJSONArray("MethodExtractorRules");
        for (int i = 0; i < configList.length(); ++i) {
            JSONObject config = configList.getJSONObject(i);
            String scopePattern = config.getString("Scope");
            String methodName = config.getString("TargetName");
            String parameterNames = config.getString("Parameters");
            this.add(new MethodExtractorRule(scopePattern, methodName, parameterNames));
        }
    }

    public boolean add(String scope, String targetName, String parameters) {
        return this.add(new MethodExtractorRule(scope, targetName, parameters));
    }

    public boolean add(MethodExtractorRule config) {
        return this.configurations.add(config);
    }

    public MethodExtractorResult findRule(String methodName) {
        for (MethodExtractorRule configuration : this.configurations) {
            Matcher m = configuration.matcher(methodName);
            if (!m.matches()) continue;
            List<String> parameterObjects = configuration.getParameterList(m);
            methodName = configuration.getMethodName(m);
            return new MethodExtractorResult(methodName, parameterObjects);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ME:[");
        for (MethodExtractorRule configuration : this.configurations) {
            sb.append(configuration.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder("{\n\"FormatVersion\":\"1.0\",\n\"MethodExtractorRules\":[\n");
        for (int i = 0; i < this.configurations.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append((CharSequence)this.configurations.get(i).toJson());
        }
        sb.append("]\n}\n");
        return sb.toString();
    }
}

