/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestExecutionException;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.results.SlimTestResult;
import fitnesse.testsystems.slim.tables.Disgracer;
import fitnesse.testsystems.slim.tables.ScriptTable;
import fitnesse.testsystems.slim.tables.SlimAssertion;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SlimTableFactory;
import fitnesse.testsystems.slim.tables.SyntaxError;
import fitnesse.testsystems.slim.tables.TableCreationException;
import fitnesse.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScenarioTable
extends SlimTable {
    private static final String instancePrefix = "scenarioTable";
    private static final String underscorePattern = "\\W_(?=\\W|$)";
    private String name;
    private List<String> inputs = new ArrayList<String>();
    private Set<String> outputs = new HashSet<String>();
    private final int colsInHeader = this.table.getColumnCountInRow(0);
    private boolean parameterized = false;
    private Pattern pattern = null;

    public ScenarioTable(Table table, String tableId, SlimTestContext testContext) {
        super(table, tableId, testContext);
    }

    @Override
    protected String getTableType() {
        return instancePrefix;
    }

    @Override
    public List<SlimAssertion> getAssertions() throws SyntaxError {
        this.parseTable();
        return Collections.emptyList();
    }

    private void parseTable() throws SyntaxError {
        this.validateHeader();
        this.parameterized = this.determineParameterized();
        this.name = this.getScenarioName();
        this.getScenarioArguments();
        this.setParameterMatchingPattern();
        this.getTestContext().addScenario(this.name, this);
    }

    protected boolean determineParameterized() {
        String firstNameCell = this.table.getCellContents(1, 0);
        return this.isNameParameterized(firstNameCell);
    }

    protected void getScenarioArguments() {
        if (this.parameterized) {
            this.getArgumentsForParameterizedName();
        } else {
            this.getArgumentsForAlternatingName();
        }
    }

    private void getArgumentsForAlternatingName() {
        for (int inputCol = 2; inputCol < this.colsInHeader; inputCol += 2) {
            String argName = this.table.getCellContents(inputCol, 0);
            this.splitInputAndOutputArguments(argName);
        }
    }

    private void splitInputAndOutputArguments(String argName) {
        if ((argName = argName.trim()).endsWith("?")) {
            String disgracedArgName = Disgracer.disgraceMethodName(argName);
            this.outputs.add(disgracedArgName);
        } else {
            String disgracedArgName = Disgracer.disgraceMethodName(argName);
            this.inputs.add(disgracedArgName);
        }
    }

    private void getArgumentsForParameterizedName() {
        String[] arguments;
        String argumentString = this.table.getCellContents(2, 0);
        for (String argument : arguments = argumentString.split(",")) {
            this.splitInputAndOutputArguments(argument);
        }
    }

    protected void addInput(String argument) {
        this.inputs.add(argument);
    }

    protected void addOutput(String argument) {
        this.outputs.add(argument);
    }

    public String getScenarioName() {
        if (this.parameterized) {
            String parameterizedName = this.table.getCellContents(1, 0);
            return this.unparameterize(parameterizedName);
        }
        return this.getNameFromAlternatingCells();
    }

    private boolean isNameParameterized(String firstNameCell) {
        Pattern regPat = Pattern.compile(underscorePattern);
        Matcher underscoreMatcher = regPat.matcher(firstNameCell);
        return underscoreMatcher.find();
    }

    private String unparameterize(String firstNameCell) {
        String name = firstNameCell.replaceAll(underscorePattern, " ").trim();
        return Disgracer.disgraceClassName(name);
    }

    private String getNameFromAlternatingCells() {
        StringBuilder nameBuffer = new StringBuilder();
        for (int nameCol = 1; nameCol < this.colsInHeader; nameCol += 2) {
            nameBuffer.append(this.table.getCellContents(nameCol, 0)).append(" ");
        }
        return Disgracer.disgraceClassName(nameBuffer.toString().trim());
    }

    private void validateHeader() throws SyntaxError {
        if (this.colsInHeader <= 1) {
            throw new SyntaxError("Scenario tables must have a name.");
        }
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getInputs() {
        return new HashSet<String>(this.inputs);
    }

    public Set<String> getOutputs() {
        return new HashSet<String>(this.outputs);
    }

    public List<SlimAssertion> call(final Map<String, String> scenarioArguments, SlimTable parentTable, int row) throws TestExecutionException {
        Table newTable = this.getTable().asTemplate(new Table.CellContentSubstitution(){

            @Override
            public String substitute(String content) throws SyntaxError {
                for (Map.Entry scenarioArgument : scenarioArguments.entrySet()) {
                    String arg = (String)scenarioArgument.getKey();
                    if (ScenarioTable.this.getInputs().contains(arg)) {
                        String argument = (String)scenarioArguments.get(arg);
                        content = StringUtils.replace(content, "@" + arg, argument);
                        content = StringUtils.replace(content, "@{" + arg + "}", argument);
                        continue;
                    }
                    throw new SyntaxError(String.format("The argument %s is not an input to the scenario.", arg));
                }
                return content;
            }
        });
        ScenarioTestContext testContext = new ScenarioTestContext(parentTable.getTestContext());
        ScriptTable t = this.createChild(testContext, parentTable, newTable);
        parentTable.addChildTable(t, row);
        List<SlimAssertion> assertions = t.getAssertions();
        assertions.add(this.makeAssertion(Instruction.NOOP_INSTRUCTION, new ScenarioExpectation(t, row)));
        return assertions;
    }

    protected ScriptTable createChild(ScenarioTestContext testContext, SlimTable parentTable, Table newTable) throws TableCreationException {
        ScriptTable scriptTable = parentTable instanceof ScriptTable ? this.createChild((ScriptTable)parentTable, newTable, (SlimTestContext)testContext) : this.createChild(this.getTestContext().getCurrentScriptClass(), newTable, (SlimTestContext)testContext);
        scriptTable.setCustomComparatorRegistry(this.customComparatorRegistry);
        return scriptTable;
    }

    protected ScriptTable createChild(ScriptTable parentScriptTable, Table newTable, SlimTestContext testContext) throws TableCreationException {
        return this.createChild(parentScriptTable.getClass(), newTable, testContext);
    }

    protected ScriptTable createChild(Class<? extends ScriptTable> parentTableClass, Table newTable, SlimTestContext testContext) throws TableCreationException {
        return SlimTableFactory.createTable(parentTableClass, newTable, this.id, testContext);
    }

    public List<SlimAssertion> call(String[] args, ScriptTable parentTable, int row) throws TestExecutionException {
        HashMap<String, String> scenarioArguments = new HashMap<String, String>();
        for (int i = 0; i < this.inputs.size() && i < args.length; ++i) {
            scenarioArguments.put(this.inputs.get(i), args[i]);
        }
        return this.call(scenarioArguments, (SlimTable)parentTable, row);
    }

    public boolean isParameterized() {
        return this.parameterized;
    }

    private void setParameterMatchingPattern() {
        String parameterizedName = null;
        if (this.parameterized) {
            parameterizedName = this.table.getCellContents(1, 0);
        } else if (!this.inputs.isEmpty()) {
            StringBuilder nameBuffer = new StringBuilder();
            for (int nameCol = 1; nameCol < this.colsInHeader; nameCol += 2) {
                String cell = this.table.getCellContents(nameCol, 0);
                nameBuffer.append(cell).append(" _ ");
            }
            parameterizedName = nameBuffer.toString().trim();
        }
        if (parameterizedName != null) {
            String patternString = StringUtils.replace(parameterizedName, "_", "(.*)");
            this.pattern = Pattern.compile(patternString);
        }
    }

    public boolean canMatchParameters(String invokingString) {
        Matcher matcher = this.getMatchingMatcher(invokingString);
        return matcher != null;
    }

    public String[] matchParameters(String invokingString) {
        String[] result = null;
        Matcher matcher = this.getMatchingMatcher(invokingString);
        if (matcher != null) {
            result = this.extractNamesFromMatcher(matcher);
        }
        return result;
    }

    private Matcher getMatchingMatcher(String invokingString) {
        Matcher matcher;
        Matcher result = null;
        if (this.pattern != null && (matcher = this.pattern.matcher(invokingString)).matches()) {
            result = matcher;
        }
        return result;
    }

    private String[] extractNamesFromMatcher(Matcher matcher) {
        String[] arguments = new String[matcher.groupCount()];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = matcher.group(i + 1);
        }
        return arguments;
    }

    public final class ScenarioTestContext
    implements SlimTestContext {
        private final SlimTestContext testContext;
        private final TestSummary testSummary = new TestSummary();

        public ScenarioTestContext(SlimTestContext testContext) {
            this.testContext = testContext;
        }

        public ScenarioTable getScenarioTable() {
            return ScenarioTable.this;
        }

        @Override
        public String getSymbol(String symbolName) {
            return this.testContext.getSymbol(symbolName);
        }

        @Override
        public Map<String, String> getSymbols() {
            return this.testContext.getSymbols();
        }

        @Override
        public void setSymbol(String symbolName, String value) {
            this.testContext.setSymbol(symbolName, value);
        }

        @Override
        public void addScenario(String scenarioName, ScenarioTable scenarioTable) {
            this.testContext.addScenario(scenarioName, scenarioTable);
        }

        @Override
        public ScenarioTable getScenario(String scenarioName) {
            return this.testContext.getScenario(scenarioName);
        }

        @Override
        public ScenarioTable getScenarioByPattern(String invokingString) {
            return this.testContext.getScenarioByPattern(invokingString);
        }

        @Override
        public Collection<ScenarioTable> getScenarios() {
            return this.testContext.getScenarios();
        }

        @Override
        public void incrementPassedTestsCount() {
            this.increment(ExecutionResult.PASS);
        }

        @Override
        public void incrementFailedTestsCount() {
            this.increment(ExecutionResult.FAIL);
        }

        @Override
        public void incrementErroredTestsCount() {
            this.increment(ExecutionResult.ERROR);
        }

        @Override
        public void incrementIgnoredTestsCount() {
            this.increment(ExecutionResult.IGNORE);
        }

        @Override
        public void increment(ExecutionResult result) {
            this.testContext.increment(result);
            this.testSummary.add(result);
        }

        @Override
        public void increment(TestSummary summary) {
            this.testContext.increment(summary);
            this.testSummary.add(summary);
        }

        ExecutionResult getExecutionResult() {
            return ExecutionResult.getExecutionResult(this.testSummary);
        }

        @Override
        public TestPage getPageToTest() {
            return this.testContext.getPageToTest();
        }

        @Override
        public void setCurrentScriptClass(Class<? extends ScriptTable> currentScriptClass) {
            this.testContext.setCurrentScriptClass(currentScriptClass);
        }

        @Override
        public Class<? extends ScriptTable> getCurrentScriptClass() {
            return this.testContext.getCurrentScriptClass();
        }

        @Override
        public void setCurrentScriptActor(String currentScriptActor) {
            this.testContext.setCurrentScriptActor(currentScriptActor);
        }

        @Override
        public String getCurrentScriptActor() {
            return this.testContext.getCurrentScriptActor();
        }
    }

    private final class ScenarioExpectation
    extends SlimTable.RowExpectation {
        private ScriptTable scriptTable;

        private ScenarioExpectation(ScriptTable scriptTable, int row) {
            super(ScenarioTable.this, -1, row);
            this.scriptTable = scriptTable;
        }

        @Override
        public TestResult evaluateExpectation(Object returnValue) {
            SlimTable parent = this.scriptTable.getParent();
            ExecutionResult testStatus = ((ScenarioTestContext)this.scriptTable.getTestContext()).getExecutionResult();
            if (ScenarioTable.this.outputs.isEmpty() || testStatus != ExecutionResult.PASS) {
                parent.getTable().updateContent(this.getRow(), new SlimTestResult(testStatus));
            }
            return null;
        }

        @Override
        protected SlimTestResult createEvaluationMessage(String actual, String expected) {
            return null;
        }
    }
}

