/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.util;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class Tree<T extends Tree<T>> {
    protected abstract T getNode();

    protected abstract List<T> getBranches();

    public boolean isLeaf() {
        return this.getBranches().size() == 0;
    }

    public T getBranch(int child) {
        return (T)((Tree)this.getBranches().get(child));
    }

    public T getLastBranch() {
        return (T)((Tree)this.getBranches().get(this.getBranches().size() - 1));
    }

    public void walkPreOrder(Consumer<T> visitNode, Predicate<T> visitBranches) {
        visitNode.accept(this.getNode());
        if (visitBranches.test(this.getNode())) {
            for (Tree branch : this.getBranches()) {
                branch.walkPreOrder(visitNode, visitBranches);
            }
        }
    }

    public void walkPreOrder(Consumer<T> visitNode) {
        this.walkPreOrder(visitNode, node -> true);
    }

    public void walkPostOrder(Consumer<T> visitNode, Predicate<T> visitBranches) {
        if (visitBranches.test(this.getNode())) {
            for (Tree branch : this.getBranches()) {
                branch.walkPostOrder(visitNode, visitBranches);
            }
        }
        visitNode.accept(this.getNode());
    }

    public void walkPostOrder(Consumer<T> visitNode) {
        this.walkPostOrder(visitNode, node -> true);
    }

    public <X, U> U collectBranches(Function<T, X> translator, U initial, BiConsumer<U, ? super X> accumulator) {
        this.getBranches().stream().map(translator).forEachOrdered(item -> accumulator.accept(initial, (Object)item));
        return initial;
    }
}

