/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.util.partitioner;

import fitnesse.util.partitioner.ListPartitioner;
import java.util.ArrayList;
import java.util.List;

public class EqualLengthListPartitioner<T>
implements ListPartitioner<T> {
    @Override
    public List<List<T>> split(List<T> source, int partitionCount) {
        int sourceSize = source.size();
        int smallerPartitionSize = sourceSize / partitionCount;
        int largerPartitionSize = smallerPartitionSize + 1;
        int fullPartitions = sourceSize % partitionCount;
        if (fullPartitions == 0) {
            fullPartitions = partitionCount;
            largerPartitionSize = smallerPartitionSize;
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>(partitionCount);
        int index = 0;
        for (int i = 0; i < partitionCount; ++i) {
            int partitionSize = i < fullPartitions ? largerPartitionSize : smallerPartitionSize;
            int end = index + partitionSize;
            List<T> partition = source.subList(index, end);
            result.add(partition);
            index = end;
        }
        return result;
    }
}

