/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.util.partitioner;

import fitnesse.util.partitioner.ListPartitioner;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class FunctionBasedListPartitioner<T>
implements ListPartitioner<T> {
    private final Function<T, Optional<Integer>> positionFunction;
    private final BiFunction<List<List<T>>, List<T>, List<List<T>>> notFoundFunction;

    public FunctionBasedListPartitioner(Function<T, Optional<Integer>> positionFunction, BiFunction<List<List<T>>, List<T>, List<List<T>>> notFoundFunction) {
        this.positionFunction = positionFunction;
        this.notFoundFunction = notFoundFunction;
    }

    @Override
    public List<List<T>> split(List<T> source, int partitionCount) {
        List<List<T>> result = new ArrayList<List<T>>(partitionCount);
        for (int j = 0; j < partitionCount; ++j) {
            result.add(new LinkedList());
        }
        List<T> notFound = this.addUsingPositionFunction(source, result);
        if (!notFound.isEmpty()) {
            List<List<T>> extraItems = this.notFoundFunction.apply(result, notFound);
            if (partitionCount < extraItems.size()) {
                throw new IllegalArgumentException("Extra items use too many partitions: " + extraItems.size());
            }
            result = this.combinePlacedAndNotFound(result, extraItems);
        }
        return result;
    }

    protected List<T> addUsingPositionFunction(List<T> source, List<List<T>> result) {
        int partitionCount = result.size();
        ArrayList<T> notFound = new ArrayList<T>();
        for (T item : source) {
            Optional<Integer> pos = this.positionFunction.apply(item);
            if (pos.isPresent()) {
                int index = pos.get();
                if (index >= 0 && index < partitionCount) {
                    result.get(index).add(item);
                    continue;
                }
                notFound.add(item);
                continue;
            }
            notFound.add(item);
        }
        return notFound;
    }

    protected List<List<T>> combinePlacedAndNotFound(List<List<T>> partitions, List<List<T>> extraItems) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(partitions.size());
        for (List<T> placed : partitions) {
            ArrayList<T> endPartition = new ArrayList<T>(placed);
            result.add(endPartition);
        }
        for (int i = 0; i < extraItems.size(); ++i) {
            List<T> extras = extraItems.get(i);
            ((List)result.get(i)).addAll(0, extras);
        }
        return result;
    }
}

