/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.util.partitioner;

import fitnesse.util.partitioner.EqualLengthListPartitioner;
import fitnesse.util.partitioner.FunctionBasedListPartitioner;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MapBasedListPartitioner<T>
extends FunctionBasedListPartitioner<T> {
    private final Map<String, Integer> positionMap;

    public MapBasedListPartitioner(Function<T, String> keyFunction, Map<String, Integer> positionMap) {
        this(keyFunction, positionMap, (parts, nf) -> new EqualLengthListPartitioner().split(nf, parts.size()));
    }

    public MapBasedListPartitioner(Function<T, String> keyFunction, Map<String, Integer> positionMap, BiFunction<List<List<T>>, List<T>, List<List<T>>> notFoundFunction) {
        super((T t) -> {
            String key = (String)keyFunction.apply(t);
            Integer value = (Integer)positionMap.get(key);
            return Optional.ofNullable(value);
        }, notFoundFunction);
        this.positionMap = positionMap;
    }

    @Override
    protected List<T> addUsingPositionFunction(List<T> source, List<List<T>> result) {
        if (this.positionMap.isEmpty()) {
            return source;
        }
        return super.addUsingPositionFunction(source, result);
    }
}

