/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public abstract class BaseWikiPage
implements WikiPage {
    protected final String name;
    protected final WikiPage parent;

    public BaseWikiPage(String name, WikiPage parent) {
        this.name = name;
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasChildPage(String pageName) {
        return this.getChildPage(pageName) != null;
    }

    @Override
    public WikiPage getParent() {
        return this.parent == null ? this : this.parent;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null || this.parent == this;
    }

    @Override
    public void remove() {
        WikiPage parent = this.getParent();
        if (parent != this) {
            parent.removeChildPage(this.getName());
        }
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.name;
    }

    @Override
    public int compareTo(WikiPage other) {
        try {
            WikiPagePath path1 = this.getFullPath();
            WikiPagePath path2 = other.getFullPath();
            return path1.compareTo(path2);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WikiPage)) {
            return false;
        }
        if (other instanceof SymbolicPage) {
            return other.equals(this);
        }
        try {
            WikiPage otherPage = (WikiPage)other;
            if (this.isRoot() && otherPage.isRoot()) {
                return this.getName().equals(otherPage.getName());
            }
            WikiPagePath path1 = this.getFullPath();
            WikiPagePath path2 = otherPage.getFullPath();
            return path1.equals(path2);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getFullPath().hashCode();
        }
        catch (Exception e) {
            return 0;
        }
    }
}

