/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.util.Clock;
import fitnesse.wiki.ApplicationVariableSource;
import fitnesse.wiki.BaseWikiPage;
import fitnesse.wiki.PageType;
import fitnesse.wiki.PageVariableSource;
import fitnesse.wiki.UrlPathVariableSource;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.WikiSourcePage;
import fitnesse.wiki.WikitextPage;
import fitnesse.wiki.fs.WikiPageProperties;
import fitnesse.wikitext.CompositeVariableSource;
import fitnesse.wikitext.MarkUpSystem;
import fitnesse.wikitext.ParsingPage;
import fitnesse.wikitext.SyntaxTree;
import fitnesse.wikitext.VariableSource;
import fitnesse.wikitext.parser.Maybe;
import java.util.Optional;

public abstract class BaseWikitextPage
extends BaseWikiPage
implements WikitextPage {
    private final VariableSource variableSource;
    private ParsingPage parsingPage;
    private SyntaxTree syntaxTree;

    protected BaseWikitextPage(String name, VariableSource variableSource) {
        this(name, null, variableSource);
    }

    protected BaseWikitextPage(String name, WikiPage parent) {
        this(name, parent, parent instanceof BaseWikitextPage ? ((BaseWikitextPage)parent).variableSource : null);
    }

    protected BaseWikitextPage(String name, WikiPage parent, VariableSource variableSource) {
        super(name, parent);
        this.variableSource = variableSource;
    }

    protected VariableSource getVariableSource() {
        return this.variableSource;
    }

    @Override
    public String getVariable(String name) {
        return this.getSyntaxTree().findVariable(name).map(value -> MarkUpSystem.make().variableValueToHtml(this.parsingPage, (String)value)).orElse(null);
    }

    @Override
    public String getHtml() {
        this.parse();
        return this.syntaxTree.translateToHtml();
    }

    @Override
    public SyntaxTree getSyntaxTree() {
        this.parse();
        return this.syntaxTree;
    }

    private void parse() {
        if (this.syntaxTree == null) {
            this.parsingPage = BaseWikitextPage.makeParsingPage(this);
            this.syntaxTree = MarkUpSystem.make().parse(this.parsingPage, this.getData().getContent());
        }
    }

    protected void resetCache() {
        this.parsingPage = null;
        this.syntaxTree = null;
    }

    public static ParsingPage makeParsingPage(BaseWikitextPage page) {
        ParsingPage.Cache cache = new ParsingPage.Cache();
        CompositeVariableSource compositeVariableSource = new CompositeVariableSource(new ApplicationVariableSource(page.variableSource), new PageVariableSource(page), new UserVariableSource(page.variableSource), cache, new ParentPageVariableSource(page), page.variableSource);
        return new ParsingPage(new WikiSourcePage(page), compositeVariableSource, cache);
    }

    public WikiPageProperty defaultPageProperties() {
        WikiPageProperties properties = new WikiPageProperties();
        properties.set("Edit");
        properties.set("Properties");
        properties.set("Refactor");
        properties.set("WhereUsed");
        properties.set("RecentChanges");
        properties.set("Files");
        properties.set("Versions");
        properties.set("Search");
        properties.setLastModificationTime(Clock.currentDate());
        PageType pageType = PageType.getPageTypeForPageName(this.getName());
        if (PageType.STATIC.equals((Object)pageType)) {
            return properties;
        }
        properties.set(pageType.toString());
        return properties;
    }

    public static class ParentPageVariableSource
    implements VariableSource {
        private final WikiPage page;

        public ParentPageVariableSource(WikiPage page) {
            this.page = page;
        }

        @Override
        public Optional<String> findVariable(String name) {
            if (this.page.isRoot()) {
                return Optional.empty();
            }
            WikiPage parentPage = this.page.getParent();
            if (parentPage instanceof WikitextPage) {
                return ((WikitextPage)((Object)parentPage)).getSyntaxTree().findVariable(name);
            }
            return Optional.ofNullable(parentPage.getVariable(name));
        }
    }

    public static class UserVariableSource
    implements VariableSource {
        private final VariableSource variableSource;

        public UserVariableSource(VariableSource variableSource) {
            this.variableSource = variableSource;
        }

        @Override
        public Optional<String> findVariable(String name) {
            Maybe<String> result;
            if (this.variableSource instanceof UrlPathVariableSource && !(result = ((UrlPathVariableSource)this.variableSource).findUrlVariable(name)).isNothing()) {
                return Optional.of(result.getValue());
            }
            return Optional.empty();
        }
    }
}

