/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wikitext.VariableSource;
import java.util.Optional;
import java.util.Properties;

public class SystemVariableSource
implements VariableSource {
    private final Properties properties;

    public SystemVariableSource(Properties properties) {
        this.properties = properties;
    }

    public SystemVariableSource() {
        this(null);
    }

    @Override
    public Optional<String> findVariable(String name) {
        return Optional.ofNullable(this.getProperty(name));
    }

    public String getProperty(String name) {
        String p = System.getenv(name);
        if (p != null) {
            return p;
        }
        p = System.getProperty(name);
        if (p != null) {
            return p;
        }
        return this.properties != null ? this.properties.getProperty(name) : null;
    }
}

