/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wikitext.VariableSource;
import fitnesse.wikitext.parser.Maybe;
import java.util.Map;
import java.util.Optional;

public class UrlPathVariableSource
implements VariableSource {
    private final VariableSource systemVariables;
    private final Map<String, String> urlParams;

    public UrlPathVariableSource(VariableSource systemVariables, Map<String, String> urlParams) {
        this.systemVariables = systemVariables;
        this.urlParams = urlParams;
    }

    @Override
    public Optional<String> findVariable(String name) {
        if (this.urlParams != null && this.urlParams.containsKey(name)) {
            return Optional.ofNullable(this.urlParams.get(name));
        }
        return this.systemVariables.findVariable(name);
    }

    public Maybe<String> findUrlVariable(String name) {
        if (this.urlParams != null && this.urlParams.containsKey(name)) {
            return new Maybe<String>(this.urlParams.get(name));
        }
        return Maybe.noString;
    }
}

