/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.util.Clock;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class WikiPageProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LAST_MODIFIED = "LastModified";
    public static final String LAST_MODIFYING_USER = "LastModifyingUser";
    public static final String HELP = "Help";
    public static final String PRUNE = "Prune";
    public static final String SEARCH = "Search";
    public static final String RECENT_CHANGES = "RecentChanges";
    public static final String FILES = "Files";
    public static final String WHERE_USED = "WhereUsed";
    public static final String REFACTOR = "Refactor";
    public static final String PROPERTIES = "Properties";
    public static final String VERSIONS = "Versions";
    public static final String EDIT = "Edit";
    public static final String SUITES = "Suites";
    public static final String SECURE_READ = "secure-read";
    public static final String SECURE_WRITE = "secure-write";
    public static final String SECURE_TEST = "secure-test";
    private String value;
    private SortedMap<String, WikiPageProperty> children = new TreeMap<String, WikiPageProperty>();
    private static ThreadLocal<DateFormat> timeFormat = new ThreadLocal();

    public WikiPageProperty() {
    }

    public WikiPageProperty(String value) {
        this.setValue(value);
    }

    public WikiPageProperty(WikiPageProperty that) {
        if (that != null && that.children != null) {
            this.children = new TreeMap<String, WikiPageProperty>(that.children);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = StringUtils.trim((String)value);
    }

    public void set(String name, WikiPageProperty child) {
        this.children.put(name, child);
    }

    public WikiPageProperty set(String name, String value) {
        WikiPageProperty child = new WikiPageProperty(value);
        this.set(name, child);
        return child;
    }

    public WikiPageProperty set(String name) {
        return this.set(name, (String)null);
    }

    public void remove(String name) {
        this.children.remove(name);
    }

    public WikiPageProperty getProperty(String name) {
        if (this.children == null) {
            return null;
        }
        return (WikiPageProperty)this.children.get(name);
    }

    public String get(String name) {
        WikiPageProperty child = this.getProperty(name);
        return child == null ? null : child.getValue();
    }

    public boolean has(String name) {
        return this.children != null && this.children.containsKey(name);
    }

    public Set<String> keySet() {
        return this.children == null ? Collections.emptySet() : this.children.keySet();
    }

    public String toString() {
        return this.toString("WikiPageProperty root", 0);
    }

    protected String toString(String key, int depth) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            buffer.append("\t");
        }
        buffer.append(key);
        if (this.getValue() != null) {
            buffer.append(" = ").append(this.getValue());
        }
        buffer.append("\n");
        for (String childKey : this.keySet()) {
            WikiPageProperty value = this.getProperty(childKey);
            if (value == null) continue;
            buffer.append(value.toString(childKey, depth + 1));
        }
        return buffer.toString();
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public Date getLastModificationTime() {
        String dateStr = this.get(LAST_MODIFIED);
        if (dateStr == null) {
            return Clock.currentDate();
        }
        try {
            return WikiPageProperty.getTimeFormat().parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to parse date '" + dateStr + "'", e);
        }
    }

    public static DateFormat getTimeFormat() {
        DateFormat format = timeFormat.get();
        if (format == null) {
            format = new SimpleDateFormat("yyyyMMddHHmmss", Locale.ROOT);
            timeFormat.set(format);
        }
        return format;
    }

    public void setLastModificationTime(Date date) {
        this.set(LAST_MODIFIED, WikiPageProperty.getTimeFormat().format(date));
    }
}

