/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.SourcePage;
import fitnesse.wikitext.parser.Maybe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class WikiSourcePage
implements SourcePage {
    private final WikiPage page;

    public WikiSourcePage(WikiPage page) {
        this.page = page;
    }

    @Override
    public String getName() {
        return this.page.getName();
    }

    @Override
    public String getFullName() {
        return this.page.getFullPath().toString();
    }

    @Override
    public String getPath() {
        return this.page.getFullPath().parentPath().toString();
    }

    @Override
    public String getFullPath() {
        return this.page.getFullPath().toString();
    }

    @Override
    public String getContent() {
        return this.page.getData().getContent();
    }

    @Override
    public boolean targetExists(String wikiWordPath) {
        WikiPagePath pathOfWikiWord = PathParser.parse(wikiWordPath);
        WikiPage parentPage = this.page.getParent();
        return parentPage.getPageCrawler().getPage(pathOfWikiWord) != null;
    }

    @Override
    public String makeFullPathOfTarget(String wikiWordPath) {
        WikiPagePath pathOfWikiWord = PathParser.parse(wikiWordPath);
        if (pathOfWikiWord == null) {
            throw new IllegalArgumentException("Can't parse path: " + wikiWordPath);
        }
        WikiPage parentPage = this.page.getParent();
        return PathParser.render(parentPage.getPageCrawler().getFullPathOfChild(pathOfWikiWord));
    }

    @Override
    public String findParentPath(String targetName) {
        String[] pathElements = targetName.split("\\.");
        String target = pathElements[0];
        PageCrawler crawler = this.page.getPageCrawler();
        WikiPage ancestor = crawler.findAncestorWithName(target);
        if (ancestor != null) {
            pathElements[0] = PathParser.render(ancestor.getFullPath());
            return "." + StringUtils.join(Arrays.asList(pathElements), (String)".");
        }
        return "." + targetName;
    }

    @Override
    public Maybe<SourcePage> findIncludedPage(String pageName) {
        PageCrawler crawler = this.page.getPageCrawler();
        WikiPagePath pagePath = PathParser.parse(pageName);
        if (pagePath == null) {
            return Maybe.nothingBecause("Page include failed because the page " + pageName + " does not have a valid wiki page name.");
        }
        WikiPage includedPage = crawler.getSiblingPage(pagePath);
        if (includedPage == null) {
            return Maybe.nothingBecause("Page include failed because the page " + pageName + " does not exist.");
        }
        if (this.isParentOf(includedPage)) {
            return Maybe.nothingBecause("Error! Cannot include parent page (" + pageName + ").");
        }
        return new Maybe<SourcePage>(new WikiSourcePage(includedPage));
    }

    @Override
    public Collection<SourcePage> getChildren() {
        ArrayList<SourcePage> children = new ArrayList<SourcePage>();
        for (WikiPage child : this.page.getChildren()) {
            children.add(new WikiSourcePage(child));
        }
        return children;
    }

    @Override
    public boolean hasProperty(String propertyKey) {
        return this.page.getData().getProperties().has(propertyKey);
    }

    @Override
    public String getProperty(String propertyKey) {
        String propertyValue = this.page.getData().getAttribute(propertyKey);
        return propertyValue != null ? propertyValue.trim() : "";
    }

    public boolean hasSymbolicLinkChild(String childName) {
        if (this.page.getData().getProperties().has("SymbolicLinks")) {
            return this.page.getData().getProperties().getProperty("SymbolicLinks").keySet().contains(childName);
        }
        return false;
    }

    private boolean isParentOf(WikiPage possibleParent) {
        for (WikiPage candidate = this.page; candidate.getParent() != candidate; candidate = candidate.getParent()) {
            if (possibleParent != candidate) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(SourcePage other) {
        return this.getName().compareTo(other.getName());
    }
}

