/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.wiki.PathParser;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.VariableTool;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageFactory;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.WikiPageUtil;
import fitnesse.wiki.fs.FileBasedWikiPage;
import fitnesse.wiki.fs.FileSystem;
import fitnesse.wiki.fs.SubWikiPageFactory;
import fitnesse.wikitext.VariableSource;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

class FileSystemSubWikiPageFactory
implements SubWikiPageFactory {
    private final File rootPath;
    private final FileSystem fileSystem;
    private final VariableSource variableSource;
    private final WikiPageFactory factory;

    public FileSystemSubWikiPageFactory(File rootPath, FileSystem fileSystem, VariableSource variableSource, WikiPageFactory factory) {
        this.rootPath = rootPath;
        this.fileSystem = fileSystem;
        this.variableSource = variableSource;
        this.factory = factory;
    }

    @Override
    public List<WikiPage> getChildren(FileBasedWikiPage page) {
        ArrayList<WikiPage> children = new ArrayList<WikiPage>();
        children.addAll(this.getNormalChildren(page));
        children.addAll(this.getSymlinkChildren(page));
        return children;
    }

    private Set<WikiPage> getNormalChildren(FileBasedWikiPage page) {
        File thisDir = page.getFileSystemPath();
        TreeSet<WikiPage> children = new TreeSet<WikiPage>();
        if (this.fileSystem.exists(thisDir)) {
            String[] subFiles;
            for (String subFile : subFiles = this.fileSystem.list(thisDir)) {
                WikiPage maybeChildPage = this.getChildPage(page, subFile);
                if (maybeChildPage == null) continue;
                children.add(maybeChildPage);
            }
        }
        return children;
    }

    private List<WikiPage> getSymlinkChildren(WikiPage page) {
        LinkedList<WikiPage> children = new LinkedList<WikiPage>();
        WikiPageProperty props = page.getData().getProperties();
        WikiPageProperty symLinksProperty = props.getProperty("SymbolicLinks");
        if (symLinksProperty != null) {
            for (String linkName : symLinksProperty.keySet()) {
                WikiPage linkedPage = this.createSymbolicPage(page, linkName);
                if (linkedPage == null || children.contains(linkedPage)) continue;
                children.add(linkedPage);
            }
        }
        return children;
    }

    @Override
    public WikiPage getChildPage(FileBasedWikiPage page, String childName) {
        File parent = page.getFileSystemPath();
        WikiPage childPage = this.makeChildPage(new File(parent, childName), childName, page);
        if (childPage == null) {
            childPage = this.createSymbolicPage(page, childName);
        }
        return childPage;
    }

    private WikiPage makeChildPage(File path, String childName, FileBasedWikiPage parent) {
        return this.factory.makePage(path, childName, parent, this.variableSource);
    }

    private WikiPage createSymbolicPage(WikiPage page, String linkName) {
        WikiPageProperty symLinkProperty = page.getData().getProperties().getProperty("SymbolicLinks");
        if (symLinkProperty == null) {
            return null;
        }
        String linkPath = symLinkProperty.get(linkName);
        if (linkPath == null) {
            return null;
        }
        if (linkPath.startsWith("file:")) {
            return this.createExternalSymbolicLink(linkPath, linkName, page);
        }
        return this.createInternalSymbolicPage(linkPath, linkName, page);
    }

    private WikiPage createExternalSymbolicLink(String linkPath, String linkName, WikiPage parent) {
        WikiPage externalRoot;
        String fullPagePath = new VariableTool(this.variableSource).replace(linkPath);
        File file = WikiPageUtil.resolveFileUri(fullPagePath, this.rootPath);
        File parentDirectory = file.getParentFile();
        if (this.fileSystem.exists(parentDirectory) && (externalRoot = this.makeChildPage(file, file.getName(), null)) != null) {
            return new SymbolicPage(linkName, externalRoot, parent);
        }
        return null;
    }

    protected WikiPage createInternalSymbolicPage(String linkPath, String linkName, WikiPage parent) {
        WikiPagePath path = PathParser.parse(linkPath);
        if (path == null) {
            return null;
        }
        WikiPage start = path.isRelativePath() ? parent.getParent() : parent;
        WikiPage wikiPage = start.getPageCrawler().getPage(path);
        if (wikiPage != null) {
            wikiPage = new SymbolicPage(linkName, wikiPage, parent);
        }
        return wikiPage;
    }
}

