/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.wiki.SystemVariableSource;
import fitnesse.wiki.UrlPathVariableSource;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageFactory;
import fitnesse.wiki.fs.FileSystem;
import fitnesse.wiki.fs.FileSystemPageFactory;
import fitnesse.wiki.fs.MemoryFileSystem;
import fitnesse.wiki.fs.MemoryVersionsController;
import fitnesse.wikitext.VariableSource;
import java.io.File;
import java.util.Map;
import java.util.Properties;

public class InMemoryPage {
    public static WikiPage makeRoot(String name) {
        return InMemoryPage.makeRoot(name, null, new MemoryFileSystem());
    }

    public static WikiPage makeRoot(String name, MemoryFileSystem fileSystem) {
        return InMemoryPage.makeRoot(name, null, fileSystem);
    }

    public static WikiPage makeRoot(String name, Map<String, String> customProperties) {
        return InMemoryPage.makeRoot(name, new MemoryFileSystem(), new UrlPathVariableSource(new SystemVariableSource(null), customProperties));
    }

    public static WikiPage makeRoot(String name, Properties properties) {
        return InMemoryPage.makeRoot(name, properties, new MemoryFileSystem());
    }

    public static WikiPage makeRoot(String name, Properties properties, MemoryFileSystem fileSystem) {
        return InMemoryPage.makeRoot(name, fileSystem, new SystemVariableSource(properties));
    }

    public static WikiPage makeRoot(String name, MemoryFileSystem fileSystem, VariableSource variableSource) {
        WikiPageFactory factory = InMemoryPage.newInstance(fileSystem);
        return factory.makePage(new File("."), name, null, variableSource);
    }

    public static WikiPageFactory newInstance() {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        return InMemoryPage.newInstance(fileSystem);
    }

    public static WikiPageFactory newInstance(FileSystem fileSystem) {
        return new FileSystemPageFactory(fileSystem, new MemoryVersionsController(fileSystem));
    }
}

