/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.util.StringUtils;
import fitnesse.wiki.BaseWikitextPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageLoadException;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.fs.FileBasedWikiPage;
import fitnesse.wiki.fs.FileVersion;
import fitnesse.wiki.fs.SubWikiPageFactory;
import fitnesse.wiki.fs.VersionsController;
import fitnesse.wikitext.ParsingPage;
import fitnesse.wikitext.VariableSource;
import fitnesse.wikitext.parser.FrontMatter;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import util.FileUtil;

public class WikiFilePage
extends BaseWikitextPage
implements FileBasedWikiPage {
    public static final String FILE_EXTENSION = ".wiki";
    public static final String ROOT_FILE_NAME = "_root.wiki";
    private static final SymbolProvider WIKI_FILE_PARSING_PROVIDER = new SymbolProvider(new SymbolType[]{FrontMatter.symbolType, SymbolType.Text});
    private final File path;
    private final VersionsController versionsController;
    private final SubWikiPageFactory subWikiPageFactory;
    private final String versionName;
    private PageData pageData;

    protected WikiFilePage(File path, String name, WikiPage parent, String versionName, VersionsController versionsController, SubWikiPageFactory subWikiPageFactory, VariableSource variableSource) {
        super(name, parent, variableSource);
        this.path = path;
        this.versionsController = versionsController;
        this.subWikiPageFactory = subWikiPageFactory;
        this.versionName = versionName;
    }

    private WikiFilePage(WikiFilePage page, String versionName) {
        this(page.path, page.getName(), page.isRoot() ? null : page.getParent(), versionName, page.versionsController, page.subWikiPageFactory, page.getVariableSource());
    }

    @Override
    public WikiPage addChildPage(String childName) {
        return new WikiFilePage(new File(this.getFileSystemPath(), childName + FILE_EXTENSION), childName, this, null, this.versionsController, this.subWikiPageFactory, this.getVariableSource());
    }

    private File getSubWikiFolder() {
        return this.path;
    }

    @Override
    public WikiPage getChildPage(String childName) {
        return this.subWikiPageFactory.getChildPage(this, childName);
    }

    @Override
    public void removeChildPage(String name) {
        WikiPage childPage = this.getChildPage(name);
        if (childPage != null) {
            childPage.remove();
        }
    }

    @Override
    public void remove() {
        try {
            this.versionsController.delete(this.path, this.getFileSystemPath());
        }
        catch (IOException e) {
            throw new WikiPageLoadException(String.format("Could not remove page %s", new WikiPagePath(this).toString()), e);
        }
    }

    @Override
    public List<WikiPage> getChildren() {
        return this.subWikiPageFactory.getChildren(this);
    }

    @Override
    public PageData getData() {
        if (this.pageData == null) {
            try {
                this.pageData = this.getDataVersion();
            }
            catch (IOException e) {
                throw new WikiPageLoadException("Could not load page data for page " + this.path.getPath(), e);
            }
        }
        return new PageData(this.pageData);
    }

    @Override
    public Collection<VersionInfo> getVersions() {
        return this.versionsController.history(this.path);
    }

    @Override
    public WikiPage getVersion(String versionName) {
        try {
            this.versionsController.getRevisionData(versionName, this.path);
        }
        catch (IOException e) {
            throw new WikiPageLoadException(String.format("Could not load version %s for page at %s", versionName, this.path.getPath()), e);
        }
        return new WikiFilePage(this, versionName);
    }

    @Override
    public VersionInfo commit(PageData data) {
        this.resetCache();
        try {
            return this.versionsController.makeVersion(new WikiFilePageVersion(data));
        }
        catch (IOException e) {
            throw new WikiPageLoadException(e);
        }
    }

    @Override
    public File getFileSystemPath() {
        if (ROOT_FILE_NAME.equals(this.path.getName())) {
            return this.path.getParentFile();
        }
        String pathStr = this.path.getPath();
        return new File(pathStr.substring(0, pathStr.length() - FILE_EXTENSION.length()));
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.pageData = null;
    }

    private PageData getDataVersion() throws IOException {
        FileVersion[] versions = this.versionsController.getRevisionData(this.versionName, this.path);
        FileVersion fileVersion = versions[0];
        String content = "";
        WikiPageProperty properties = this.defaultPageProperties();
        if (fileVersion != null) {
            try {
                String fileContent = this.loadContent(fileVersion);
                ParsingPage parsingPage = WikiFilePage.makeParsingPage(this);
                Symbol syntaxTree = Parser.make(parsingPage, fileContent, WIKI_FILE_PARSING_PROVIDER).parse();
                if (!syntaxTree.getChildren().isEmpty()) {
                    Symbol maybeFrontMatter = syntaxTree.getChildren().get(0);
                    if (maybeFrontMatter.isType(FrontMatter.symbolType)) {
                        properties = this.mergeWikiPageProperties(properties, maybeFrontMatter);
                        if (syntaxTree.getChildren().size() > 1) {
                            content = fileContent.substring(maybeFrontMatter.getEndOffset());
                        }
                    } else {
                        content = fileContent;
                    }
                }
                properties.setLastModificationTime(fileVersion.getLastModificationTime());
            }
            catch (IOException e) {
                throw new WikiPageLoadException(e);
            }
        }
        this.pageData = new PageData(content, properties);
        return this.pageData;
    }

    private WikiPageProperty mergeWikiPageProperties(WikiPageProperty properties, Symbol frontMatter) {
        for (Symbol keyValue : frontMatter.getChildren()) {
            if (!keyValue.isType(FrontMatter.keyValueSymbolType)) continue;
            String key = keyValue.getChildren().get(0).getContent();
            String value = keyValue.getChildren().get(1).getContent();
            if (this.isBooleanProperty(key)) {
                if (StringUtils.isBlank(value) || this.isTruthy(value)) {
                    properties.set(key, value);
                    continue;
                }
                if (!this.isFalsy(value)) continue;
                properties.remove(key);
                continue;
            }
            WikiPageProperty symLinks = properties.set(key, value);
            for (int i = 2; i < keyValue.getChildren().size(); ++i) {
                Symbol subProperty = keyValue.getChildren().get(i);
                assert (subProperty.isType(FrontMatter.keyValueSymbolType));
                String linkName = subProperty.getChildren().get(0).getContent();
                String linkPath = subProperty.getChildren().get(1).getContent();
                symLinks.set(linkName, linkPath);
            }
        }
        return properties;
    }

    private boolean isBooleanProperty(String key) {
        return this.qualifiesAs(key, PageData.PAGE_TYPE_ATTRIBUTES) || this.qualifiesAs(key, PageData.NON_SECURITY_ATTRIBUTES) || this.qualifiesAs(key, PageData.SECURITY_ATTRIBUTES);
    }

    private boolean isTruthy(String value) {
        return this.qualifiesAs(value.toLowerCase(), new String[]{"y", "yes", "t", "true", "1"});
    }

    private boolean isFalsy(String value) {
        return this.qualifiesAs(value.toLowerCase(), new String[]{"n", "no", "f", "false", "0"});
    }

    private boolean qualifiesAs(String value, String[] qualifiers) {
        for (String q : qualifiers) {
            if (!q.equals(value)) continue;
            return true;
        }
        return false;
    }

    private String loadContent(FileVersion fileVersion) throws IOException {
        try (InputStream content = fileVersion.getContent();){
            String string = FileUtil.toString(content);
            return string;
        }
    }

    private String propertiesYaml(WikiPageProperty pageProperties) {
        WikiPageProperty defaultProperties = this.defaultPageProperties();
        ArrayList<String> lines = new ArrayList<String>();
        for (String key : pageProperties.keySet()) {
            if (this.isBooleanProperty(key)) {
                if (defaultProperties.has(key)) continue;
                lines.add(key);
                continue;
            }
            if ("LastModified".equals(key)) continue;
            StringBuilder builder = new StringBuilder();
            builder.append(key);
            if (!StringUtils.isBlank(pageProperties.get(key))) {
                builder.append(": ").append(pageProperties.get(key));
            }
            WikiPageProperty subProperty = pageProperties.getProperty(key);
            for (String pageName : subProperty.keySet()) {
                builder.append("\n  ").append(pageName).append(": ").append(subProperty.get(pageName));
            }
            lines.add(builder.toString());
        }
        for (String key : defaultProperties.keySet()) {
            if (!this.isBooleanProperty(key) || pageProperties.has(key)) continue;
            lines.add(key + ": no");
        }
        Collections.sort(lines);
        return lines.isEmpty() ? "" : "---\n" + org.apache.commons.lang3.StringUtils.join(lines, (char)'\n') + "\n---\n";
    }

    private class WikiFilePageVersion
    implements FileVersion {
        private final PageData data;

        public WikiFilePageVersion(PageData data) {
            this.data = new PageData(data);
        }

        @Override
        public File getFile() {
            return WikiFilePage.this.path;
        }

        @Override
        public InputStream getContent() throws IOException {
            String yaml = WikiFilePage.this.propertiesYaml(this.data.getProperties());
            String content = yaml + this.data.getContent();
            return new ByteArrayInputStream(content.getBytes(FileUtil.CHARENCODING));
        }

        @Override
        public String getAuthor() {
            return this.data.getAttribute("LastModifyingUser");
        }

        @Override
        public Date getLastModificationTime() {
            return this.data.getProperties().getLastModificationTime();
        }
    }
}

