/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.ConfigurationParameter;
import fitnesse.components.ComponentFactory;
import fitnesse.wiki.NoSuchVersionException;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.fs.DiskFileSystem;
import fitnesse.wiki.fs.FileVersion;
import fitnesse.wiki.fs.SimpleFileVersionsController;
import fitnesse.wiki.fs.VersionsController;
import fitnesse.wiki.fs.ZipFileVersionInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import util.FileUtil;

public class ZipFileVersionsController
implements VersionsController {
    private static final Logger LOG = Logger.getLogger(ZipFileVersionsController.class.getName());
    private static final Pattern ZIP_FILE_PATTERN = Pattern.compile("(\\S+)?\\d+(~\\d+)?\\.zip");
    public static final String ZIP_EXTENSION = ".zip";
    private final int daysTillVersionsExpire;
    private VersionsController persistence;

    public ZipFileVersionsController(ComponentFactory componentFactory) {
        this(ZipFileVersionsController.getVersionDays(componentFactory));
    }

    public ZipFileVersionsController() {
        this(14);
    }

    public ZipFileVersionsController(int versionDays) {
        this.daysTillVersionsExpire = versionDays;
        this.persistence = new SimpleFileVersionsController(new DiskFileSystem());
    }

    private static int getVersionDays(ComponentFactory componentFactory) {
        String days = componentFactory.getProperty(ConfigurationParameter.VERSIONS_CONTROLLER_DAYS.getKey());
        return days == null ? 14 : Integer.parseInt(days);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileVersion[] getRevisionData(String label, File ... files) throws IOException {
        Object[] objectArray;
        if (label == null) {
            return this.persistence.getRevisionData(null, files);
        }
        File file = new File(files[0].getParentFile(), label + ZIP_EXTENSION);
        if (!file.exists()) {
            throw new NoSuchVersionException("There is no version '" + label + "'");
        }
        ZipFile zipFile = null;
        FileVersion[] versions = new FileVersion[files.length];
        int counter = 0;
        try {
            zipFile = new ZipFile(file);
            for (File f : files) {
                ZipFileVersion version = this.loadZipEntry(zipFile, f);
                if (version == null) continue;
                versions[counter++] = version;
            }
            objectArray = versions;
        }
        catch (Throwable throwable) {
            FileUtil.close(zipFile);
            throw throwable;
        }
        FileUtil.close(zipFile);
        return objectArray;
    }

    @Override
    public Collection<VersionInfo> history(File ... pageFiles) {
        File dir = this.commonBaseDir(pageFiles);
        File[] files = dir.listFiles();
        HashSet<VersionInfo> versions = new HashSet<VersionInfo>();
        if (files != null) {
            for (File file : files) {
                if (!this.isVersionFile(file) || !this.isZipForFiles(file, pageFiles)) continue;
                versions.add(ZipFileVersionInfo.makeVersionInfo(file));
            }
        }
        return versions;
    }

    private boolean isZipForFiles(File zipFile, File ... containedFiles) {
        List<String> zipFileNames = this.getFileNamesInZipFile(zipFile);
        for (File f : containedFiles) {
            if (!zipFileNames.contains(f.getName())) continue;
            return true;
        }
        return false;
    }

    private List<String> getFileNamesInZipFile(File zipFile) {
        ArrayList<String> names = new ArrayList<String>();
        try (ZipInputStream zos = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry = zos.getNextEntry();
            while (entry != null) {
                names.add(entry.getName());
                entry = zos.getNextEntry();
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, String.format("Could not read zip file %s", zipFile), e);
        }
        return names;
    }

    @Override
    public VersionInfo makeVersion(FileVersion ... fileVersions) throws IOException {
        File commonBaseDir = this.commonBaseDir(fileVersions);
        String versionName = this.makeVersionName(commonBaseDir, fileVersions[0]);
        File zipFile = new File(commonBaseDir, versionName + ZIP_EXTENSION);
        this.makeZipVersion(zipFile, fileVersions);
        this.pruneVersions(this.history(this.toFiles(fileVersions)));
        this.persistence.makeVersion(fileVersions);
        return new VersionInfo(versionName, fileVersions[0].getAuthor(), fileVersions[0].getLastModificationTime());
    }

    @Override
    public VersionInfo addDirectory(FileVersion filePath) throws IOException {
        return this.persistence.addDirectory(filePath);
    }

    @Override
    public void rename(FileVersion fileVersion, File originalFile) throws IOException {
        this.persistence.rename(fileVersion, originalFile);
    }

    @Override
    public void delete(File ... files) throws IOException {
        this.persistence.delete(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeZipVersion(File zipFile, FileVersion ... fileVersions) throws IOException {
        if (!this.exists(fileVersions)) {
            return;
        }
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            for (FileVersion fileVersion : fileVersions) {
                this.addToZip(fileVersion.getFile(), zos);
            }
        }
        finally {
            try {
                if (zos != null) {
                    zos.finish();
                    FileUtil.close(zos);
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unable to create zip file", e);
            }
        }
    }

    private boolean exists(FileVersion[] fileVersions) {
        for (FileVersion fileVersion : fileVersions) {
            if (!fileVersion.getFile().exists()) continue;
            return true;
        }
        return false;
    }

    private File[] toFiles(FileVersion[] fileVersions) {
        File[] files = new File[fileVersions.length];
        for (int i = 0; i < fileVersions.length; ++i) {
            files[i] = fileVersions[i].getFile();
        }
        return files;
    }

    private File commonBaseDir(FileVersion[] fileVersions) {
        return this.commonBaseDir(fileVersions[0].getFile());
    }

    private File commonBaseDir(File ... files) {
        return files[0].getParentFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToZip(File file, ZipOutputStream zos) throws IOException {
        FileInputStream is;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            LOG.warning("File " + file.getAbsolutePath() + " not found. It can not be saved in this version.");
            return;
        }
        try {
            ZipEntry entry = new ZipEntry(file.getName());
            zos.putNextEntry(entry);
            int size = (int)file.length();
            byte[] bytes = new byte[size];
            is.read(bytes);
            zos.write(bytes, 0, size);
        }
        finally {
            FileUtil.close(is);
        }
    }

    private boolean isVersionFile(File file) {
        return ZIP_FILE_PATTERN.matcher(file.getName()).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipFileVersion loadZipEntry(ZipFile zipFile, File file) throws IOException {
        ZipEntry contentEntry = zipFile.getEntry(file.getName());
        if (contentEntry != null) {
            InputStream contentIS = null;
            try {
                contentIS = zipFile.getInputStream(contentEntry);
                ZipFileVersion zipFileVersion = new ZipFileVersion(file, FileUtil.toString(contentIS), new Date(contentEntry.getTime()));
                return zipFileVersion;
            }
            finally {
                try {
                    if (contentIS != null) {
                        contentIS.close();
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Unable to read zip file contents", e);
                }
            }
        }
        return null;
    }

    private String makeVersionName(File baseDir, FileVersion fileVersion) {
        Date time = fileVersion.getLastModificationTime();
        String versionName = WikiImportProperty.getTimeFormat().format(time);
        String user = fileVersion.getAuthor();
        if (user != null && !"".equals(user)) {
            versionName = user + "-" + versionName;
        }
        String name = versionName;
        int counter = 1;
        while (new File(baseDir, name + ZIP_EXTENSION).exists()) {
            name = versionName + "~" + counter++;
        }
        return name;
    }

    private void pruneVersions(Collection<VersionInfo> versions) {
        List<VersionInfo> versionsList = this.makeSortedVersionList(versions);
        if (!versions.isEmpty()) {
            VersionInfo lastVersion = versionsList.get(versionsList.size() - 1);
            Date expirationDate = this.makeVersionExpirationDate(lastVersion);
            for (VersionInfo version : versionsList) {
                Date thisDate = version.getCreationTime();
                if (!thisDate.before(expirationDate) && !thisDate.equals(expirationDate)) continue;
                ((ZipFileVersionInfo)version).getFile().delete();
            }
        }
    }

    private List<VersionInfo> makeSortedVersionList(Collection<VersionInfo> versions) {
        ArrayList<VersionInfo> versionsList = new ArrayList<VersionInfo>(versions);
        Collections.sort(versionsList);
        return versionsList;
    }

    private Date makeVersionExpirationDate(VersionInfo lastVersion) {
        Date dateOfLastVersion = lastVersion.getCreationTime();
        GregorianCalendar expirationDate = new GregorianCalendar();
        expirationDate.setTime(dateOfLastVersion);
        expirationDate.add(5, -this.daysTillVersionsExpire);
        return expirationDate.getTime();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class ZipFileVersion
    implements FileVersion {
        private final File file;
        private final String content;
        private final Date lastModified;

        public ZipFileVersion(File file, String content, Date lastModified) {
            this.file = file;
            this.content = content;
            this.lastModified = lastModified;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public InputStream getContent() throws IOException {
            return new ByteArrayInputStream(this.content.getBytes(FileUtil.CHARENCODING));
        }

        @Override
        public String getAuthor() {
            return null;
        }

        @Override
        public Date getLastModificationTime() {
            return this.lastModified;
        }
    }
}

