/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.refactoring;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.NoPruningStrategy;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.WikiSourcePage;
import fitnesse.wiki.refactoring.ChangeReference;
import fitnesse.wikitext.MarkUpSystem;
import java.util.Optional;
import java.util.Set;

public class ReferenceRenamingTraverser
implements TraversalListener<WikiPage> {
    private final ChangeReference changeReference;

    public static void renameReferences(WikiPage root, ChangeReference changeReference) {
        root.getPageCrawler().traverse(new ReferenceRenamingTraverser(changeReference), new NoPruningStrategy());
    }

    private ReferenceRenamingTraverser(ChangeReference changeReference) {
        this.changeReference = changeReference;
    }

    @Override
    public void process(WikiPage currentPage) {
        PageData data = currentPage.getData();
        boolean pageHasChanged = this.checkSymbolicLinks(currentPage, data);
        if (pageHasChanged |= this.updatePageContent(currentPage, data)) {
            currentPage.commit(data);
        }
    }

    private boolean checkSymbolicLinks(WikiPage currentPage, PageData data) {
        boolean pageHasChanged = false;
        WikiPageProperty suiteProperty = data.getProperties().getProperty("SymbolicLinks");
        if (suiteProperty != null) {
            Set<String> links = suiteProperty.keySet();
            for (String link : links) {
                String linkTarget = suiteProperty.get(link);
                Optional<String> renamedLinkTarget = this.changeReference.changeReference(currentPage, linkTarget);
                if (!renamedLinkTarget.isPresent()) continue;
                suiteProperty.set(link, renamedLinkTarget.get());
                pageHasChanged = true;
            }
        }
        return pageHasChanged;
    }

    private boolean updatePageContent(WikiPage currentPage, PageData data) {
        boolean pageHasChanged;
        String content = data.getContent();
        String newContent = this.getUpdatedPageContent(currentPage);
        boolean bl = pageHasChanged = !newContent.equals(content);
        if (pageHasChanged) {
            data.setContent(newContent);
        }
        return pageHasChanged;
    }

    private String getUpdatedPageContent(WikiPage currentPage) {
        return MarkUpSystem.make().changeReferences(new WikiSourcePage(currentPage), reference -> this.changeReference.changeReference(currentPage, (String)reference));
    }
}

